<?php

namespace Database\Seeders;

use App\Enums\Activity;
use App\Enums\Ask;
use App\Enums\ShippingType;
use App\Enums\Status;
use App\Models\Product;
use App\Models\ProductSeo;
use App\Models\ProductTag;
use App\Models\ProductTax;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Dipokhalder\EnvEditor\EnvEditor;
use Picqer\Barcode\BarcodeGeneratorJPG;

class ProductTableSeeder extends Seeder
{


    public function run(): void
    {
        $fashionProducts = [
            [
                'info'       => [
                    'name'             => 'Classic Sweatshirt',
                    'category'         => 3,
                    'brand'            => 1,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The Classic French Terry Crew brings super-soft comfort to a style that's tried and</p><p>true. It's a top you'll want to wear every day, and it's comfortable and durable enough that you can.&nbsp;&nbsp;</p><p><br></p><p>Soft Comfort</p><p>French terry fabric is lightweight, soft, and comfortable.&nbsp;&nbsp;</p><p><br></p><p>Durable Style</p><p>Reinforced shoulder seams and ribbing enhance durability.&nbsp;&nbsp;</p><p><br></p><p>Product Details</p><ul><li>Ribbing at the hem and cuffs</li><li>Back neck tape</li><li>Fabric:80% cotton: 20% polyester</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Black/White</li><li>Style: BV2666-010</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Sweatshirt',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>The Classic French Terry Crew brings super-soft comfort to a style that's tried and</p><p>true. It's a top you'll want to wear every day, and it's comfortable and durable enough that you can.&nbsp;&nbsp;</p><p><br></p><p>Soft Comfort</p><p>French terry fabric is lightweight, soft, and comfortable.&nbsp;&nbsp;</p><p><br></p><p>Durable Style</p><p>Reinforced shoulder seams and ribbing enhance durability.&nbsp;&nbsp;</p><p><br></p><p>Product Details</p><ul><li>Ribbing at the hem and cuffs</li><li>Back neck tape</li><li>Fabric:80% cotton: 20% polyester</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Black/White</li><li>Style: BV2666-010</li></ul>"
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classics French Men\'s Hoodie',
                    'category'         => 3,
                    'brand'            => 2,
                    'buying_price'     => 80,
                    'selling_price'    => 150,
                    'variation_price'  => 150,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The Classic French Terry Crew brings super-soft comfort to a style that's tried and</p><p>true. It's a top you'll want to wear every day, and it's comfortable and durable enough that you can.&nbsp;&nbsp;</p><p><br></p><p>Soft Comfort</p><p>French terry fabric is lightweight, soft, and comfortable.&nbsp;&nbsp;</p><p><br></p><p>Durable Style</p><p>Reinforced shoulder seams and ribbing enhance durability.&nbsp;&nbsp;</p><p><br></p><p>Product Details</p><ul><li>Ribbing at the hem and cuffs</li><li>Back neck tape</li><li>Fabric:80% cotton: 20% polyester</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Black/White</li><li>Style: BV2666-010</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classics French Men\'s Hoodie',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>The Classic French Terry Crew brings super-soft comfort to a style that's tried and</p><p>true. It's a top you'll want to wear every day, and it's comfortable and durable enough that you can.&nbsp;&nbsp;</p><p><br></p><p>Soft Comfort</p><p>French terry fabric is lightweight, soft, and comfortable.&nbsp;&nbsp;</p><p><br></p><p>Durable Style</p><p>Reinforced shoulder seams and ribbing enhance durability.&nbsp;&nbsp;</p><p><br></p><p>Product Details</p><ul><li>Ribbing at the hem and cuffs</li><li>Back neck tape</li><li>Fabric:80% cotton: 20% polyester</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Black/White</li><li>Style: BV2666-010</li></ul>"
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Team Red Hoodie',
                    'category'         => 3,
                    'brand'            => 3,
                    'buying_price'     => 80,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The Classic French Terry Crew brings super-soft comfort to a style that's tried and</p><p>true. It's a top you'll want to wear every day, and it's comfortable and durable enough that you can.&nbsp;&nbsp;</p><p><br></p><p>Soft Comfort</p><p>French terry fabric is lightweight, soft, and comfortable.&nbsp;&nbsp;</p><p><br></p><p>Durable Style</p><p>Reinforced shoulder seams and ribbing enhance durability.&nbsp;&nbsp;</p><p><br></p><p>Product Details</p><ul><li>Ribbing at the hem and cuffs</li><li>Back neck tape</li><li>Fabric:80% cotton: 20% polyester</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Black/White</li><li>Style: BV2666-010</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Team Red Hoodie',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>The Classic French Terry Crew brings super-soft comfort to a style that's tried and</p><p>true. It's a top you'll want to wear every day, and it's comfortable and durable enough that you can.&nbsp;&nbsp;</p><p><br></p><p>Soft Comfort</p><p>French terry fabric is lightweight, soft, and comfortable.&nbsp;&nbsp;</p><p><br></p><p>Durable Style</p><p>Reinforced shoulder seams and ribbing enhance durability.&nbsp;&nbsp;</p><p><br></p><p>Product Details</p><ul><li>Ribbing at the hem and cuffs</li><li>Back neck tape</li><li>Fabric:80% cotton: 20% polyester</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Black/White</li><li>Style: BV2666-010</li></ul>"
                ],
                'taxes'      => [4],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Black Jacket',
                    'category'         => 4,
                    'brand'            => 4,
                    'buying_price'     => 100,
                    'selling_price'    => 130,
                    'variation_price'  => 130,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>This insulated puffer gives you all the warmth you'll need to hit the streets during the coldest months and look fresh doing it. Panels of thick Thermore® Ecodown® insulation are complemented by the roomy hood and storm flap to shield you from the elements.&nbsp;&nbsp;</p><p><br></p><p>Warm Fill </p><p>Blown-In Thermore Ecodown insulation mimics the loft, look, and feel of down insulation while using a construction featuring 100% recycled materials.&nbsp;&nbsp;</p><p><br></p><p>Reliable and Dry </p><p>Tough Ripstop fabric is smooth, durable, and water-repellent, helping you stay dry in wet weather.&nbsp;&nbsp;</p><p><br></p><p>Stay-Warm Comfort </p><p>Nike Therma-FIT technology helps manage your body's natural heat to help keep you warm in cold-weather conditions.&nbsp;&nbsp;</p><p><br></p><p>More Benefits</p><ul><li>The hood can easily be removed and reattached using the hefty metal zip.</li><li>Hook-and-loop closure where the collar meets the hood helps you shield your face from the chill.</li><li>The thick metal zip is rugged and durable.</li><li>Storm flap helps keep the cold air and moisture out.</li><li>Smooth taffeta lining makes it easy to layer underneath.</li></ul><p><br></p><p>Product Details</p><ul><li>Loose fit for a roomy feel</li><li>Embroidered Swoosh design on the left of the chest</li><li>Deep hand pockets</li><li>Hook-and-loop cuff adjusters</li><li>100% polyester.</li><li>Machine wash</li><li>Imported</li><li>Color Shown: Rattan/Rattan</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Black Jacket',
                    'meta_keyword' => ['Jackets', 'Vesets'],
                    'description'  => "<p>This insulated puffer gives you all the warmth you'll need to hit the streets during the coldest months and look fresh doing it. Panels of thick Thermore® Ecodown® insulation are complemented by the roomy hood and storm flap to shield you from the elements.&nbsp;&nbsp;</p><p><br></p><p>Warm Fill </p><p>Blown-In Thermore Ecodown insulation mimics the loft, look, and feel of down insulation while using a construction featuring 100% recycled materials.&nbsp;&nbsp;</p><p><br></p><p>Reliable and Dry </p><p>Tough Ripstop fabric is smooth, durable, and water-repellent, helping you stay dry in wet weather.&nbsp;&nbsp;</p><p><br></p><p>Stay-Warm Comfort </p><p>Nike Therma-FIT technology helps manage your body's natural heat to help keep you warm in cold-weather conditions.&nbsp;&nbsp;</p><p><br></p><p>More Benefits</p><ul><li>The hood can easily be removed and reattached using the hefty metal zip.</li><li>Hook-and-loop closure where the collar meets the hood helps you shield your face from the chill.</li><li>The thick metal zip is rugged and durable.</li><li>Storm flap helps keep the cold air and moisture out.</li><li>Smooth taffeta lining makes it easy to layer underneath.</li></ul><p><br></p><p>Product Details</p><ul><li>Loose fit for a roomy feel</li><li>Embroidered Swoosh design on the left of the chest</li><li>Deep hand pockets</li><li>Hook-and-loop cuff adjusters</li><li>100% polyester.</li><li>Machine wash</li><li>Imported</li><li>Color Shown: Rattan/Rattan</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Jackets', 'Vesets'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Brown Jacket',
                    'category'         => 4,
                    'brand'            => 5,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>This insulated puffer gives you all the warmth you'll need to hit the streets during the coldest months and look fresh doing it. Panels of thick Thermore® Ecodown® insulation are complemented by the roomy hood and storm flap to shield you from the elements.&nbsp;&nbsp;</p><p><br></p><p>Warm Fill </p><p>Blown-In Thermore Ecodown insulation mimics the loft, look, and feel of down insulation while using a construction featuring 100% recycled materials.&nbsp;&nbsp;</p><p><br></p><p>Reliable and Dry </p><p>Tough Ripstop fabric is smooth, durable, and water-repellent, helping you stay dry in wet weather.&nbsp;&nbsp;</p><p><br></p><p>Stay-Warm Comfort </p><p>Nike Therma-FIT technology helps manage your body's natural heat to help keep you warm in cold-weather conditions.&nbsp;&nbsp;</p><p><br></p><p>More Benefits</p><ul><li>The hood can easily be removed and reattached using the hefty metal zip.</li><li>Hook-and-loop closure where the collar meets the hood helps you shield your face from the chill.</li><li>The thick metal zip is rugged and durable.</li><li>Storm flap helps keep the cold air and moisture out.</li><li>Smooth taffeta lining makes it easy to layer underneath.</li></ul><p><br></p><p>Product Details</p><ul><li>Loose fit for a roomy feel</li><li>Embroidered Swoosh design on the left of the chest</li><li>Deep hand pockets</li><li>Hook-and-loop cuff adjusters</li><li>100% polyester.</li><li>Machine wash</li><li>Imported</li><li>Color Shown: Rattan/Rattan</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Brown Jacket',
                    'meta_keyword' => ['Jackets', 'Vesets'],
                    'description'  => "<p>This insulated puffer gives you all the warmth you'll need to hit the streets during the coldest months and look fresh doing it. Panels of thick Thermore® Ecodown® insulation are complemented by the roomy hood and storm flap to shield you from the elements.&nbsp;&nbsp;</p><p><br></p><p>Warm Fill </p><p>Blown-In Thermore Ecodown insulation mimics the loft, look, and feel of down insulation while using a construction featuring 100% recycled materials.&nbsp;&nbsp;</p><p><br></p><p>Reliable and Dry </p><p>Tough Ripstop fabric is smooth, durable, and water-repellent, helping you stay dry in wet weather.&nbsp;&nbsp;</p><p><br></p><p>Stay-Warm Comfort </p><p>Nike Therma-FIT technology helps manage your body's natural heat to help keep you warm in cold-weather conditions.&nbsp;&nbsp;</p><p><br></p><p>More Benefits</p><ul><li>The hood can easily be removed and reattached using the hefty metal zip.</li><li>Hook-and-loop closure where the collar meets the hood helps you shield your face from the chill.</li><li>The thick metal zip is rugged and durable.</li><li>Storm flap helps keep the cold air and moisture out.</li><li>Smooth taffeta lining makes it easy to layer underneath.</li></ul><p><br></p><p>Product Details</p><ul><li>Loose fit for a roomy feel</li><li>Embroidered Swoosh design on the left of the chest</li><li>Deep hand pockets</li><li>Hook-and-loop cuff adjusters</li><li>100% polyester.</li><li>Machine wash</li><li>Imported</li><li>Color Shown: Rattan/Rattan</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Jackets', 'Vesets'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Denim Jacket',
                    'category'         => 4,
                    'brand'            => 6,
                    'buying_price'     => 120,
                    'selling_price'    => 150,
                    'variation_price'  => 150,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>This insulated puffer gives you all the warmth you'll need to hit the streets during the coldest months and look fresh doing it. Panels of thick Thermore® Ecodown® insulation are complemented by the roomy hood and storm flap to shield you from the elements.&nbsp;&nbsp;</p><p><br></p><p>Warm Fill </p><p>Blown-In Thermore Ecodown insulation mimics the loft, look, and feel of down insulation while using a construction featuring 100% recycled materials.&nbsp;&nbsp;</p><p><br></p><p>Reliable and Dry </p><p>Tough Ripstop fabric is smooth, durable, and water-repellent, helping you stay dry in wet weather.&nbsp;&nbsp;</p><p><br></p><p>Stay-Warm Comfort </p><p>Nike Therma-FIT technology helps manage your body's natural heat to help keep you warm in cold-weather conditions.&nbsp;&nbsp;</p><p><br></p><p>More Benefits</p><ul><li>The hood can easily be removed and reattached using the hefty metal zip.</li><li>Hook-and-loop closure where the collar meets the hood helps you shield your face from the chill.</li><li>The thick metal zip is rugged and durable.</li><li>Storm flap helps keep the cold air and moisture out.</li><li>Smooth taffeta lining makes it easy to layer underneath.</li></ul><p><br></p><p>Product Details</p><ul><li>Loose fit for a roomy feel</li><li>Embroidered Swoosh design on the left of the chest</li><li>Deep hand pockets</li><li>Hook-and-loop cuff adjusters</li><li>100% polyester.</li><li>Machine wash</li><li>Imported</li><li>Color Shown: Rattan/Rattan</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Denim Jacket',
                    'meta_keyword' => ['Jackets', 'Vesets'],
                    'description'  => "<p>This insulated puffer gives you all the warmth you'll need to hit the streets during the coldest months and look fresh doing it. Panels of thick Thermore® Ecodown® insulation are complemented by the roomy hood and storm flap to shield you from the elements.&nbsp;&nbsp;</p><p><br></p><p>Warm Fill </p><p>Blown-In Thermore Ecodown insulation mimics the loft, look, and feel of down insulation while using a construction featuring 100% recycled materials.&nbsp;&nbsp;</p><p><br></p><p>Reliable and Dry </p><p>Tough Ripstop fabric is smooth, durable, and water-repellent, helping you stay dry in wet weather.&nbsp;&nbsp;</p><p><br></p><p>Stay-Warm Comfort </p><p>Nike Therma-FIT technology helps manage your body's natural heat to help keep you warm in cold-weather conditions.&nbsp;&nbsp;</p><p><br></p><p>More Benefits</p><ul><li>The hood can easily be removed and reattached using the hefty metal zip.</li><li>Hook-and-loop closure where the collar meets the hood helps you shield your face from the chill.</li><li>The thick metal zip is rugged and durable.</li><li>Storm flap helps keep the cold air and moisture out.</li><li>Smooth taffeta lining makes it easy to layer underneath.</li></ul><p><br></p><p>Product Details</p><ul><li>Loose fit for a roomy feel</li><li>Embroidered Swoosh design on the left of the chest</li><li>Deep hand pockets</li><li>Hook-and-loop cuff adjusters</li><li>100% polyester.</li><li>Machine wash</li><li>Imported</li><li>Color Shown: Rattan/Rattan</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Jackets', 'Vesets'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Chino',
                    'category'         => 5,
                    'brand'            => 7,
                    'buying_price'     => 50,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Chino',
                    'meta_keyword' => ['Pants', 'Tights'],
                    'description'  => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Pants', 'Tights'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Gabardine Pant',
                    'category'         => 5,
                    'brand'            => 8,
                    'buying_price'     => 40,
                    'selling_price'    => 50,
                    'variation_price'  => 50,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Gabardine Pant',
                    'meta_keyword' => ['Pants', 'Tights'],
                    'description'  => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Pants', 'Tights'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Denim Jeans',
                    'category'         => 5,
                    'brand'            => 1,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Denim Jeans',
                    'meta_keyword' => ['Pants', 'Tights'],
                    'description'  => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Pants', 'Tights'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Slim Fit Jeans',
                    'category'         => 5,
                    'brand'            => 2,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Slim Fit Jeans',
                    'meta_keyword' => ['Pants', 'Tights'],
                    'description'  => "<p>Whether you're hitting the pavement with your community or on your own, there's nothing quite like the joyful rush of a runner's high. One thing's for sure: comfort and support are paramount in maximizing your daily run. Introducing the Own the Run Woven Astro Pants — the ultimate running companion when it's too cold out for shorts. Crafted from a comfy weave fabric, they're cut for a regular fit with a drawcord waist to keep them in place. Sweat-wicking AEROREADY helps keep you feeling dry, while various pockets allow you to stash essentials on the go. Reflective details shine in low light, so you can fit your run schedule around your busy everyday life.</p><p><br></p><ul><li>Regular fit</li><li>Drawcord on elastic waist</li><li>100% recycled polyester plain weave</li><li>Moisture-absorbing AEROREADY</li><li>Side pockets with zip coin pocket inside one pocket</li><li>Mesh leg pocket</li><li>Reflective details</li><li>Imported</li><li>Product color: Black</li><li>Product code: HR6611</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Pants', 'Tights'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Gabardine',
                    'category'         => 6,
                    'brand'            => 3,
                    'buying_price'     => 50,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Made from soft French terry fabric for casual, daily comfort, our Nike Club Alumni shorts feature raw edges on the pocket openings and hem for a vintage, worn-in look. Whether you're cruising campus or reliving the glory days, the stretchy elastic waistband has an external drawcord to let you find the right fit.</p><p><br></p><p>Benefits</p><ul><li>Soft French terry fabric has a lightweight feel—like your classic sweats.</li><li>Roomy through the hips and thighs for a laid-back look and feel.</li><li>Exposed raw edges at the pocket openings and hem give these shorts a vintage finish.</li></ul><p><br></p><p>Product Details</p><ul><li>Printed Futura logo on left thigh</li><li>Pockets and back pocket</li><li>Body: 58% cotton/23% rayon/19% polyester. Front Pocket Knuckle Side: 100% cotton.&nbsp;</li><li>Waistband: 49% rayon/47% cotton/4% elastane.</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Dark Grey Heather/White/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Gabardine',
                    'meta_keyword' => ['Shorts'],
                    'description'  => "<p>Made from soft French terry fabric for casual, daily comfort, our Nike Club Alumni shorts feature raw edges on the pocket openings and hem for a vintage, worn-in look. Whether you're cruising campus or reliving the glory days, the stretchy elastic waistband has an external drawcord to let you find the right fit.</p><p><br></p><p>Benefits</p><ul><li>Soft French terry fabric has a lightweight feel—like your classic sweats.</li><li>Roomy through the hips and thighs for a laid-back look and feel.</li><li>Exposed raw edges at the pocket openings and hem give these shorts a vintage finish.</li></ul><p><br></p><p>Product Details</p><ul><li>Printed Futura logo on left thigh</li><li>Pockets and back pocket</li><li>Body: 58% cotton/23% rayon/19% polyester. Front Pocket Knuckle Side: 100% cotton.&nbsp;</li><li>Waistband: 49% rayon/47% cotton/4% elastane.</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Dark Grey Heather/White/White</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Shorts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Sportswear',
                    'category'         => 6,
                    'brand'            => 4,
                    'buying_price'     => 40,
                    'selling_price'    => 70,
                    'variation_price'  => 70,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Made from soft French terry fabric for casual, daily comfort, our Nike Club Alumni shorts feature raw edges on the pocket openings and hem for a vintage, worn-in look. Whether you're cruising campus or reliving the glory days, the stretchy elastic waistband has an external drawcord to let you find the right fit.</p><p><br></p><p>Benefits</p><ul><li>Soft French terry fabric has a lightweight feel—like your classic sweats.</li><li>Roomy through the hips and thighs for a laid-back look and feel.</li><li>Exposed raw edges at the pocket openings and hem give these shorts a vintage finish.</li></ul><p><br></p><p>Product Details</p><ul><li>Printed Futura logo on left thigh</li><li>Pockets and back pocket</li><li>Body: 58% cotton/23% rayon/19% polyester. Front Pocket Knuckle Side: 100% cotton.&nbsp;</li><li>Waistband: 49% rayon/47% cotton/4% elastane.</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Dark Grey Heather/White/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Sportswear',
                    'meta_keyword' => ['Shorts'],
                    'description'  => "<p>Made from soft French terry fabric for casual, daily comfort, our Nike Club Alumni shorts feature raw edges on the pocket openings and hem for a vintage, worn-in look. Whether you're cruising campus or reliving the glory days, the stretchy elastic waistband has an external drawcord to let you find the right fit.</p><p><br></p><p>Benefits</p><ul><li>Soft French terry fabric has a lightweight feel—like your classic sweats.</li><li>Roomy through the hips and thighs for a laid-back look and feel.</li><li>Exposed raw edges at the pocket openings and hem give these shorts a vintage finish.</li></ul><p><br></p><p>Product Details</p><ul><li>Printed Futura logo on left thigh</li><li>Pockets and back pocket</li><li>Body: 58% cotton/23% rayon/19% polyester. Front Pocket Knuckle Side: 100% cotton.&nbsp;</li><li>Waistband: 49% rayon/47% cotton/4% elastane.</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Dark Grey Heather/White/White</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Shorts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-fit Miler',
                    'category'         => 7,
                    'brand'            => 5,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dri-fit Miler',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-fit Pro',
                    'category'         => 7,
                    'brand'            => 6,
                    'buying_price'     => 80,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dri-fit Pro',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-fit Striker',
                    'category'         => 7,
                    'brand'            => 7,
                    'buying_price'     => 100,
                    'selling_price'    => 110,
                    'variation_price'  => 110,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dri-fit Striker',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Sportswear Club',
                    'category'         => 7,
                    'brand'            => 8,
                    'buying_price'     => 40,
                    'selling_price'    => 70,
                    'variation_price'  => 70,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Sportswear Club',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Sportswear Ready',
                    'category'         => 7,
                    'brand'            => 1,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Sportswear Ready',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>The sweat-wicking Ready Top keeps you fresh for all your fitness activities. It's cut with a relaxed fit with quick-drying, breathable fabric to help you stay cool when your workout heats up. Plus, it has angled sleeves for better movement, whether you're lifting at the gym or stretching outside.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Breathable mesh fabric helps keep you cool.</li><li>Raglan sleeves are angled so you get the most out of your arm movement.</li><li>Flat stitching feels smooth against the skin.</li></ul><p><br></p><p>Product Details</p><ul><li>92% polyester 8% elastane</li><li>Machine wash</li><li>Imported</li><li>Colour Shown: Mineral Teal/Heather/Black</li><li>Style: DV9815-379</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'men/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'GT Cut 2',
                    'category'         => 9,
                    'brand'            => 2,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Create space, stop in an instant, shoot off the dribble—do it all with the Nike Precision 6. It's designed to enable quick players to shift speeds and change directions while staying in control. From the plush collar and tongue to the modified herringbone traction, the agile low top lets you make the most of your skills while pushing the tempo of the game.</p><p><br></p><p>All-game comfort</p><p>The plush foam on the collar and tongue enhances the feeling of comfort around the ankle and over the top of the foot—areas where you want no distractions.</p><p><br></p><p>Sculpted for speed</p><p>The sculpted foam midsole feels soft and supportive, providing cushioning for the game's non-stop movement.</p><p><br></p><p>Traction for quick cuts</p><p>Herringbone traction provides a multi-directional grip, great for players who rely on their quickness and cutting ability. The rubber wraps up the sides of the forefoot to give you traction on your edges.</p><p><br></p><p>Secure your fit</p><p>Updated lace positioning and midfoot webbing loops help you stay secure in your shoes and free from distractions.</p><p><br></p><p>More benefits</p><ul><li>A low collar provides mobility at the ankle.</li><li>Visible cut-out in the foam helps reduce weight.</li></ul><p><br></p><p>Product details</p><ul><li>No-sew overlays</li><li>Moulded Swoosh logo</li><li>Color Shown: White/University Gold/Midnight Navy</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'GT Cut 2',
                    'meta_keyword' => ['BasketBall'],
                    'description'  => "<p>Create space, stop in an instant, shoot off the dribble—do it all with the Nike Precision 6. It's designed to enable quick players to shift speeds and change directions while staying in control. From the plush collar and tongue to the modified herringbone traction, the agile low top lets you make the most of your skills while pushing the tempo of the game.</p><p><br></p><p>All-game comfort</p><p>The plush foam on the collar and tongue enhances the feeling of comfort around the ankle and over the top of the foot—areas where you want no distractions.</p><p><br></p><p>Sculpted for speed</p><p>The sculpted foam midsole feels soft and supportive, providing cushioning for the game's non-stop movement.</p><p><br></p><p>Traction for quick cuts</p><p>Herringbone traction provides a multi-directional grip, great for players who rely on their quickness and cutting ability. The rubber wraps up the sides of the forefoot to give you traction on your edges.</p><p><br></p><p>Secure your fit</p><p>Updated lace positioning and midfoot webbing loops help you stay secure in your shoes and free from distractions.</p><p><br></p><p>More benefits</p><ul><li>A low collar provides mobility at the ankle.</li><li>Visible cut-out in the foam helps reduce weight.</li></ul><p><br></p><p>Product details</p><ul><li>No-sew overlays</li><li>Moulded Swoosh logo</li><li>Color Shown: White/University Gold/Midnight Navy</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['BasketBall'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Luka 1',
                    'category'         => 9,
                    'brand'            => 3,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Create space, stop in an instant, shoot off the dribble—do it all with the Nike Precision 6. It's designed to enable quick players to shift speeds and change directions while staying in control. From the plush collar and tongue to the modified herringbone traction, the agile low top lets you make the most of your skills while pushing the tempo of the game.</p><p><br></p><p>All-game comfort</p><p>The plush foam on the collar and tongue enhances the feeling of comfort around the ankle and over the top of the foot—areas where you want no distractions.</p><p><br></p><p>Sculpted for speed</p><p>The sculpted foam midsole feels soft and supportive, providing cushioning for the game's non-stop movement.</p><p><br></p><p>Traction for quick cuts</p><p>Herringbone traction provides a multi-directional grip, great for players who rely on their quickness and cutting ability. The rubber wraps up the sides of the forefoot to give you traction on your edges.</p><p><br></p><p>Secure your fit</p><p>Updated lace positioning and midfoot webbing loops help you stay secure in your shoes and free from distractions.</p><p><br></p><p>More benefits</p><ul><li>A low collar provides mobility at the ankle.</li><li>Visible cut-out in the foam helps reduce weight.</li></ul><p><br></p><p>Product details</p><ul><li>No-sew overlays</li><li>Moulded Swoosh logo</li><li>Color Shown: White/University Gold/Midnight Navy</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Luka 1',
                    'meta_keyword' => ['BasketBall'],
                    'description'  => "<p>Create space, stop in an instant, shoot off the dribble—do it all with the Nike Precision 6. It's designed to enable quick players to shift speeds and change directions while staying in control. From the plush collar and tongue to the modified herringbone traction, the agile low top lets you make the most of your skills while pushing the tempo of the game.</p><p><br></p><p>All-game comfort</p><p>The plush foam on the collar and tongue enhances the feeling of comfort around the ankle and over the top of the foot—areas where you want no distractions.</p><p><br></p><p>Sculpted for speed</p><p>The sculpted foam midsole feels soft and supportive, providing cushioning for the game's non-stop movement.</p><p><br></p><p>Traction for quick cuts</p><p>Herringbone traction provides a multi-directional grip, great for players who rely on their quickness and cutting ability. The rubber wraps up the sides of the forefoot to give you traction on your edges.</p><p><br></p><p>Secure your fit</p><p>Updated lace positioning and midfoot webbing loops help you stay secure in your shoes and free from distractions.</p><p><br></p><p>More benefits</p><ul><li>A low collar provides mobility at the ankle.</li><li>Visible cut-out in the foam helps reduce weight.</li></ul><p><br></p><p>Product details</p><ul><li>No-sew overlays</li><li>Moulded Swoosh logo</li><li>Color Shown: White/University Gold/Midnight Navy</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['BasketBall'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Air Max',
                    'category'         => 10,
                    'brand'            => 4,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Comfort and big attitude in the Nike Air Max 270. The design draws inspiration from Air Max icons, showcasing Nike's greatest innovation with its large window and fresh array of colors.</p><p><br></p><p>Benefits</p><ul><li>The Max Air 270 unit delivers unrivaled, all-day comfort.</li><li>The sleek, running-inspired design roots you into everything Nike.</li><li>Woven and synthetic fabric on the upper provides a lightweight fit and airy feel.</li><li>The foam midsole feels soft and comfortable.</li><li>The stretchy inner sleeve and bootie-like construction create a personalized fit.</li><li>The rubber on the outsole adds traction and durability.</li></ul><p><br></p><p>Product Details</p><ul><li>Mesh details for an airy feel</li><li>Synthetic and textile upper.</li><li>2-piece midsole</li><li>Color Shown: Black/White/Solar Red/Anthracite</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Air Max',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Comfort and big attitude in the Nike Air Max 270. The design draws inspiration from Air Max icons, showcasing Nike's greatest innovation with its large window and fresh array of colors.</p><p><br></p><p>Benefits</p><ul><li>The Max Air 270 unit delivers unrivaled, all-day comfort.</li><li>The sleek, running-inspired design roots you into everything Nike.</li><li>Woven and synthetic fabric on the upper provides a lightweight fit and airy feel.</li><li>The foam midsole feels soft and comfortable.</li><li>The stretchy inner sleeve and bootie-like construction create a personalized fit.</li><li>The rubber on the outsole adds traction and durability.</li></ul><p><br></p><p>Product Details</p><ul><li>Mesh details for an airy feel</li><li>Synthetic and textile upper.</li><li>2-piece midsole</li><li>Color Shown: Black/White/Solar Red/Anthracite</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Running'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Pegasus Turbo',
                    'category'         => 10,
                    'brand'            => 5,
                    'buying_price'     => 120,
                    'selling_price'    => 150,
                    'variation_price'  => 150,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Comfort and big attitude in the Nike Air Max 270. The design draws inspiration from Air Max icons, showcasing Nike's greatest innovation with its large window and fresh array of colors.</p><p><br></p><p>Benefits</p><ul><li>The Max Air 270 unit delivers unrivaled, all-day comfort.</li><li>The sleek, running-inspired design roots you into everything Nike.</li><li>Woven and synthetic fabric on the upper provides a lightweight fit and airy feel.</li><li>The foam midsole feels soft and comfortable.</li><li>The stretchy inner sleeve and bootie-like construction create a personalized fit.</li><li>The rubber on the outsole adds traction and durability.</li></ul><p><br></p><p>Product Details</p><ul><li>Mesh details for an airy feel</li><li>Synthetic and textile upper.</li><li>2-piece midsole</li><li>Color Shown: Black/White/Solar Red/Anthracite</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Pegasus Turbo',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Comfort and big attitude in the Nike Air Max 270. The design draws inspiration from Air Max icons, showcasing Nike's greatest innovation with its large window and fresh array of colors.</p><p><br></p><p>Benefits</p><ul><li>The Max Air 270 unit delivers unrivaled, all-day comfort.</li><li>The sleek, running-inspired design roots you into everything Nike.</li><li>Woven and synthetic fabric on the upper provides a lightweight fit and airy feel.</li><li>The foam midsole feels soft and comfortable.</li><li>The stretchy inner sleeve and bootie-like construction create a personalized fit.</li><li>The rubber on the outsole adds traction and durability.</li></ul><p><br></p><p>Product Details</p><ul><li>Mesh details for an airy feel</li><li>Synthetic and textile upper.</li><li>2-piece midsole</li><li>Color Shown: Black/White/Solar Red/Anthracite</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Running'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Vapor Max',
                    'category'         => 10,
                    'brand'            => 6,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Comfort and big attitude in the Nike Air Max 270. The design draws inspiration from Air Max icons, showcasing Nike's greatest innovation with its large window and fresh array of colors.</p><p><br></p><p>Benefits</p><ul><li>The Max Air 270 unit delivers unrivaled, all-day comfort.</li><li>The sleek, running-inspired design roots you into everything Nike.</li><li>Woven and synthetic fabric on the upper provides a lightweight fit and airy feel.</li><li>The foam midsole feels soft and comfortable.</li><li>The stretchy inner sleeve and bootie-like construction create a personalized fit.</li><li>The rubber on the outsole adds traction and durability.</li></ul><p><br></p><p>Product Details</p><ul><li>Mesh details for an airy feel</li><li>Synthetic and textile upper.</li><li>2-piece midsole</li><li>Color Shown: Black/White/Solar Red/Anthracite</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Vapor Max',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Comfort and big attitude in the Nike Air Max 270. The design draws inspiration from Air Max icons, showcasing Nike's greatest innovation with its large window and fresh array of colors.</p><p><br></p><p>Benefits</p><ul><li>The Max Air 270 unit delivers unrivaled, all-day comfort.</li><li>The sleek, running-inspired design roots you into everything Nike.</li><li>Woven and synthetic fabric on the upper provides a lightweight fit and airy feel.</li><li>The foam midsole feels soft and comfortable.</li><li>The stretchy inner sleeve and bootie-like construction create a personalized fit.</li><li>The rubber on the outsole adds traction and durability.</li></ul><p><br></p><p>Product Details</p><ul><li>Mesh details for an airy feel</li><li>Synthetic and textile upper.</li><li>2-piece midsole</li><li>Color Shown: Black/White/Solar Red/Anthracite</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Running'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Ball Dream Nitro™ Slides',
                    'category'         => 11,
                    'brand'            => 7,
                    'buying_price'     => 50,
                    'selling_price'    => 70,
                    'variation_price'  => 70,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Combining the best of comfort and casual style, the Softride Slide is the perfect addition to your fashion arsenal. Whether you’re strutting the summer streets or cooling off after a workout, they’re a must-have for every trendsetter. The Softride footbed guarantees your feet are well looked after, while the synthetic strap is enhanced with soft padding for the ultimate cushioned fit.</p><p><br></p><p>Details</p><ul><li>Synthetic upper</li><li>Soft moulded footbed</li><li>CMEVA midsole</li><li>Light moulded CMEVA outsole</li><li>PUMA No. 1 Logo at front</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Ball Dream Nitro™ Slides',
                    'meta_keyword' => ['Sandals', 'Slides'],
                    'description'  => "<p>Combining the best of comfort and casual style, the Softride Slide is the perfect addition to your fashion arsenal. Whether you’re strutting the summer streets or cooling off after a workout, they’re a must-have for every trendsetter. The Softride footbed guarantees your feet are well looked after, while the synthetic strap is enhanced with soft padding for the ultimate cushioned fit.</p><p><br></p><p>Details</p><ul><li>Synthetic upper</li><li>Soft moulded footbed</li><li>CMEVA midsole</li><li>Light moulded CMEVA outsole</li><li>PUMA No. 1 Logo at front</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Sandals', 'Slides'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Leadcat Slide',
                    'category'         => 11,
                    'brand'            => 8,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Combining the best of comfort and casual style, the Softride Slide is the perfect addition to your fashion arsenal. Whether you’re strutting the summer streets or cooling off after a workout, they’re a must-have for every trendsetter. The Softride footbed guarantees your feet are well looked after, while the synthetic strap is enhanced with soft padding for the ultimate cushioned fit.</p><p><br></p><p>Details</p><ul><li>Synthetic upper</li><li>Soft moulded footbed</li><li>CMEVA midsole</li><li>Light moulded CMEVA outsole</li><li>PUMA No. 1 Logo at front</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Leadcat Slide',
                    'meta_keyword' => ['Sandals', 'Slides'],
                    'description'  => "<p>Combining the best of comfort and casual style, the Softride Slide is the perfect addition to your fashion arsenal. Whether you’re strutting the summer streets or cooling off after a workout, they’re a must-have for every trendsetter. The Softride footbed guarantees your feet are well looked after, while the synthetic strap is enhanced with soft padding for the ultimate cushioned fit.</p><p><br></p><p>Details</p><ul><li>Synthetic upper</li><li>Soft moulded footbed</li><li>CMEVA midsole</li><li>Light moulded CMEVA outsole</li><li>PUMA No. 1 Logo at front</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Sandals', 'Slides'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Slipstream Sandal',
                    'category'         => 11,
                    'brand'            => 1,
                    'buying_price'     => 100,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Combining the best of comfort and casual style, the Softride Slide is the perfect addition to your fashion arsenal. Whether you’re strutting the summer streets or cooling off after a workout, they’re a must-have for every trendsetter. The Softride footbed guarantees your feet are well looked after, while the synthetic strap is enhanced with soft padding for the ultimate cushioned fit.</p><p><br></p><p>Details</p><ul><li>Synthetic upper</li><li>Soft moulded footbed</li><li>CMEVA midsole</li><li>Light moulded CMEVA outsole</li><li>PUMA No. 1 Logo at front</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Slipstream Sandal',
                    'meta_keyword' => ['Sandals', 'Slides'],
                    'description'  => "<p>Combining the best of comfort and casual style, the Softride Slide is the perfect addition to your fashion arsenal. Whether you’re strutting the summer streets or cooling off after a workout, they’re a must-have for every trendsetter. The Softride footbed guarantees your feet are well looked after, while the synthetic strap is enhanced with soft padding for the ultimate cushioned fit.</p><p><br></p><p>Details</p><ul><li>Synthetic upper</li><li>Soft moulded footbed</li><li>CMEVA midsole</li><li>Light moulded CMEVA outsole</li><li>PUMA No. 1 Logo at front</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Sandals', 'Slides'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Black Sneaker',
                    'category'         => 12,
                    'brand'            => 2,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Black Sneaker',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Sneakers'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic White Sneaker',
                    'category'         => 12,
                    'brand'            => 3,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic White Sneaker',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Sneakers'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dior High Sneaker',
                    'category'         => 12,
                    'brand'            => 4,
                    'buying_price'     => 160,
                    'selling_price'    => 180,
                    'variation_price'  => 180,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dior High Sneaker',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Sneakers'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dior University Blue',
                    'category'         => 12,
                    'brand'            => 5,
                    'buying_price'     => 180,
                    'selling_price'    => 200,
                    'variation_price'  => 200,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dior University Blue',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Sneakers'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Nike Low Sneaker',
                    'category'         => 12,
                    'brand'            => 6,
                    'buying_price'     => 200,
                    'selling_price'    => 220,
                    'variation_price'  => 220,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Nike Low Sneaker',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>The radiance lives on with the B-ball original. Crossing hardwood comfort with off-court flair, it puts a fresh spin on what you know best: '80s-inspired construction, bold details, and nothin'-but-net style.</p><p><br></p><p>Benefits</p><ul><li>From tough stitching to pristine leather, it delivers a durable style that's smoother than backboard glass.</li><li>Originally designed for performance hoops, Nike Air cushioning delivers lasting comfort.</li><li>Rubber outsole with pivot circles adds traction and durability.</li><li>Padded, low-cut collar looks sleek and feels great.</li><li>Colour Shown: Black/Black/White</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Sneakers'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'GX Academy',
                    'category'         => 13,
                    'brand'            => 7,
                    'buying_price'     => 220,
                    'selling_price'    => 240,
                    'variation_price'  => 240,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Looking to take your game and creative ethos to the next level? Academy boots give you the precision touch you need to let your innermost playing instincts dazzle. Featuring NikeSkin, a mesh touch zone for enhanced ball control and an agility plate that's designed to swerve and sprint with you, it's ready to ignite your spontaneous playmaking spirit. Make your own style with a ridiculously extensive palette of colour options and hit the pitch with full creative control.</p><p><br></p><p>Pick Your Palette</p><p>Go with bright, neon colours that speak to your flashy skills or earth tones that let your game do the talking.</p><p><br></p><p>Fill Your Plate</p><p>Choose from 7 different plate colours. If you pick firm ground for your plate type, you can go with a solid colour (7 different colours) or metallic (3 different colours). If you see it, you can paint it.</p><p><br></p><p>Contoured For Comfort</p><p>Asymmetry in the heel provides comfort. Soft elements in the heel make for an easy break-in process and help reduce irritation and pressure without compromising stability and structure.</p><p><br></p><p>More Benefits</p><ul><li>Dynamic Fit collar wraps your ankle in soft, stretchy fabric for a secure feel.</li><li>The cushioned insole provides comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Our Members are one of a kind, and your shoes are too. Each pair is proudly made one at a time, by hand. Good things are worth the wait.</li><li>Your initials? A nickname? Or something else that's so you. Get personal with a customisable inscription on your shoes. Plus, your name is on the box.</li><li>With our 3D builder, watch your creation come alive as you experiment with all kinds of design choices.</li><li>For use on natural and synthetic surfaces</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'GX Academy',
                    'meta_keyword' => ['Soccer'],
                    'description'  => "<p>Looking to take your game and creative ethos to the next level? Academy boots give you the precision touch you need to let your innermost playing instincts dazzle. Featuring NikeSkin, a mesh touch zone for enhanced ball control and an agility plate that's designed to swerve and sprint with you, it's ready to ignite your spontaneous playmaking spirit. Make your own style with a ridiculously extensive palette of colour options and hit the pitch with full creative control.</p><p><br></p><p>Pick Your Palette</p><p>Go with bright, neon colours that speak to your flashy skills or earth tones that let your game do the talking.</p><p><br></p><p>Fill Your Plate</p><p>Choose from 7 different plate colours. If you pick firm ground for your plate type, you can go with a solid colour (7 different colours) or metallic (3 different colours). If you see it, you can paint it.</p><p><br></p><p>Contoured For Comfort</p><p>Asymmetry in the heel provides comfort. Soft elements in the heel make for an easy break-in process and help reduce irritation and pressure without compromising stability and structure.</p><p><br></p><p>More Benefits</p><ul><li>Dynamic Fit collar wraps your ankle in soft, stretchy fabric for a secure feel.</li><li>The cushioned insole provides comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Our Members are one of a kind, and your shoes are too. Each pair is proudly made one at a time, by hand. Good things are worth the wait.</li><li>Your initials? A nickname? Or something else that's so you. Get personal with a customisable inscription on your shoes. Plus, your name is on the box.</li><li>With our 3D builder, watch your creation come alive as you experiment with all kinds of design choices.</li><li>For use on natural and synthetic surfaces</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Soccer'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Phantom GX',
                    'category'         => 13,
                    'brand'            => 8,
                    'buying_price'     => 240,
                    'selling_price'    => 260,
                    'variation_price'  => 260,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Looking to take your game and creative ethos to the next level? Academy boots give you the precision touch you need to let your innermost playing instincts dazzle. Featuring NikeSkin, a mesh touch zone for enhanced ball control and an agility plate that's designed to swerve and sprint with you, it's ready to ignite your spontaneous playmaking spirit. Make your own style with a ridiculously extensive palette of colour options and hit the pitch with full creative control.</p><p><br></p><p>Pick Your Palette</p><p>Go with bright, neon colours that speak to your flashy skills or earth tones that let your game do the talking.</p><p><br></p><p>Fill Your Plate</p><p>Choose from 7 different plate colours. If you pick firm ground for your plate type, you can go with a solid colour (7 different colours) or metallic (3 different colours). If you see it, you can paint it.</p><p><br></p><p>Contoured For Comfort</p><p>Asymmetry in the heel provides comfort. Soft elements in the heel make for an easy break-in process and help reduce irritation and pressure without compromising stability and structure.</p><p><br></p><p>More Benefits</p><ul><li>Dynamic Fit collar wraps your ankle in soft, stretchy fabric for a secure feel.</li><li>The cushioned insole provides comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Our Members are one of a kind, and your shoes are too. Each pair is proudly made one at a time, by hand. Good things are worth the wait.</li><li>Your initials? A nickname? Or something else that's so you. Get personal with a customisable inscription on your shoes. Plus, your name is on the box.</li><li>With our 3D builder, watch your creation come alive as you experiment with all kinds of design choices.</li><li>For use on natural and synthetic surfaces</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Phantom GX',
                    'meta_keyword' => ['Soccer'],
                    'description'  => "<p>Looking to take your game and creative ethos to the next level? Academy boots give you the precision touch you need to let your innermost playing instincts dazzle. Featuring NikeSkin, a mesh touch zone for enhanced ball control and an agility plate that's designed to swerve and sprint with you, it's ready to ignite your spontaneous playmaking spirit. Make your own style with a ridiculously extensive palette of colour options and hit the pitch with full creative control.</p><p><br></p><p>Pick Your Palette</p><p>Go with bright, neon colours that speak to your flashy skills or earth tones that let your game do the talking.</p><p><br></p><p>Fill Your Plate</p><p>Choose from 7 different plate colours. If you pick firm ground for your plate type, you can go with a solid colour (7 different colours) or metallic (3 different colours). If you see it, you can paint it.</p><p><br></p><p>Contoured For Comfort</p><p>Asymmetry in the heel provides comfort. Soft elements in the heel make for an easy break-in process and help reduce irritation and pressure without compromising stability and structure.</p><p><br></p><p>More Benefits</p><ul><li>Dynamic Fit collar wraps your ankle in soft, stretchy fabric for a secure feel.</li><li>The cushioned insole provides comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Our Members are one of a kind, and your shoes are too. Each pair is proudly made one at a time, by hand. Good things are worth the wait.</li><li>Your initials? A nickname? Or something else that's so you. Get personal with a customisable inscription on your shoes. Plus, your name is on the box.</li><li>With our 3D builder, watch your creation come alive as you experiment with all kinds of design choices.</li><li>For use on natural and synthetic surfaces</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Soccer'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Phantom Luna',
                    'category'         => 13,
                    'brand'            => 1,
                    'buying_price'     => 260,
                    'selling_price'    => 280,
                    'variation_price'  => 280,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Looking to take your game and creative ethos to the next level? Academy boots give you the precision touch you need to let your innermost playing instincts dazzle. Featuring NikeSkin, a mesh touch zone for enhanced ball control and an agility plate that's designed to swerve and sprint with you, it's ready to ignite your spontaneous playmaking spirit. Make your own style with a ridiculously extensive palette of colour options and hit the pitch with full creative control.</p><p><br></p><p>Pick Your Palette</p><p>Go with bright, neon colours that speak to your flashy skills or earth tones that let your game do the talking.</p><p><br></p><p>Fill Your Plate</p><p>Choose from 7 different plate colours. If you pick firm ground for your plate type, you can go with a solid colour (7 different colours) or metallic (3 different colours). If you see it, you can paint it.</p><p><br></p><p>Contoured For Comfort</p><p>Asymmetry in the heel provides comfort. Soft elements in the heel make for an easy break-in process and help reduce irritation and pressure without compromising stability and structure.</p><p><br></p><p>More Benefits</p><ul><li>Dynamic Fit collar wraps your ankle in soft, stretchy fabric for a secure feel.</li><li>The cushioned insole provides comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Our Members are one of a kind, and your shoes are too. Each pair is proudly made one at a time, by hand. Good things are worth the wait.</li><li>Your initials? A nickname? Or something else that's so you. Get personal with a customisable inscription on your shoes. Plus, your name is on the box.</li><li>With our 3D builder, watch your creation come alive as you experiment with all kinds of design choices.</li><li>For use on natural and synthetic surfaces</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Phantom Luna',
                    'meta_keyword' => ['Soccer'],
                    'description'  => "<p>Looking to take your game and creative ethos to the next level? Academy boots give you the precision touch you need to let your innermost playing instincts dazzle. Featuring NikeSkin, a mesh touch zone for enhanced ball control and an agility plate that's designed to swerve and sprint with you, it's ready to ignite your spontaneous playmaking spirit. Make your own style with a ridiculously extensive palette of colour options and hit the pitch with full creative control.</p><p><br></p><p>Pick Your Palette</p><p>Go with bright, neon colours that speak to your flashy skills or earth tones that let your game do the talking.</p><p><br></p><p>Fill Your Plate</p><p>Choose from 7 different plate colours. If you pick firm ground for your plate type, you can go with a solid colour (7 different colours) or metallic (3 different colours). If you see it, you can paint it.</p><p><br></p><p>Contoured For Comfort</p><p>Asymmetry in the heel provides comfort. Soft elements in the heel make for an easy break-in process and help reduce irritation and pressure without compromising stability and structure.</p><p><br></p><p>More Benefits</p><ul><li>Dynamic Fit collar wraps your ankle in soft, stretchy fabric for a secure feel.</li><li>The cushioned insole provides comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Our Members are one of a kind, and your shoes are too. Each pair is proudly made one at a time, by hand. Good things are worth the wait.</li><li>Your initials? A nickname? Or something else that's so you. Get personal with a customisable inscription on your shoes. Plus, your name is on the box.</li><li>With our 3D builder, watch your creation come alive as you experiment with all kinds of design choices.</li><li>For use on natural and synthetic surfaces</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Soccer'],
                'image_path' => 'men/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Official Team Bag',
                    'category'         => 15,
                    'brand'            => 2,
                    'buying_price'     => 240,
                    'selling_price'    => 260,
                    'variation_price'  => 260,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The Nike Utility Power Duffel Bag keeps your gear secure and ready for use while commuting to and from training sessions. Multiple pockets organize your essentials, while several handles offer versatile carrying options.</p><p><br></p><p>Secure Storage</p><p>The zipped main pocket provides easy access and loading. The internal sleeve helps keep small items in place and organized.</p><p><br></p><p>Built to Last</p><p>Durable construction helps keep your cargo safe when you're on the move.</p><p><br></p><p>Easy to Carry</p><p>An adjustable shoulder strap and dual handles give you comfortable carrying options.</p><p><br></p><p>Benefits</p><ul><li>Zipped exterior pockets keep small items closed and organized.</li><li>Built-in ventilation lets your gear breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Dimensions: 48cm L x 23cm W x 23cm H (approx.)</li><li>31L</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li><li>Color Shown: Black/Black/Enigma Stone</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Phantom Luna',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>The Nike Utility Power Duffel Bag keeps your gear secure and ready for use while commuting to and from training sessions. Multiple pockets organize your essentials, while several handles offer versatile carrying options.</p><p><br></p><p>Secure Storage</p><p>The zipped main pocket provides easy access and loading. The internal sleeve helps keep small items in place and organized.</p><p><br></p><p>Built to Last</p><p>Durable construction helps keep your cargo safe when you're on the move.</p><p><br></p><p>Easy to Carry</p><p>An adjustable shoulder strap and dual handles give you comfortable carrying options.</p><p><br></p><p>Benefits</p><ul><li>Zipped exterior pockets keep small items closed and organized.</li><li>Built-in ventilation lets your gear breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Dimensions: 48cm L x 23cm W x 23cm H (approx.)</li><li>31L</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li><li>Color Shown: Black/Black/Enigma Stone</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Utility Power Bag',
                    'category'         => 15,
                    'brand'            => 3,
                    'buying_price'     => 250,
                    'selling_price'    => 270,
                    'variation_price'  => 270,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>The Nike Utility Power Duffel Bag keeps your gear secure and ready for use while commuting to and from training sessions. Multiple pockets organize your essentials, while several handles offer versatile carrying options.</p><p><br></p><p>Secure Storage</p><p>The zipped main pocket provides easy access and loading. The internal sleeve helps keep small items in place and organized.</p><p><br></p><p>Built to Last</p><p>Durable construction helps keep your cargo safe when you're on the move.</p><p><br></p><p>Easy to Carry</p><p>An adjustable shoulder strap and dual handles give you comfortable carrying options.</p><p><br></p><p>Benefits</p><ul><li>Zipped exterior pockets keep small items closed and organized.</li><li>Built-in ventilation lets your gear breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Dimensions: 48cm L x 23cm W x 23cm H (approx.)</li><li>31L</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li><li>Color Shown: Black/Black/Enigma Stone</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Utility Power Bag',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>The Nike Utility Power Duffel Bag keeps your gear secure and ready for use while commuting to and from training sessions. Multiple pockets organize your essentials, while several handles offer versatile carrying options.</p><p><br></p><p>Secure Storage</p><p>The zipped main pocket provides easy access and loading. The internal sleeve helps keep small items in place and organized.</p><p><br></p><p>Built to Last</p><p>Durable construction helps keep your cargo safe when you're on the move.</p><p><br></p><p>Easy to Carry</p><p>An adjustable shoulder strap and dual handles give you comfortable carrying options.</p><p><br></p><p>Benefits</p><ul><li>Zipped exterior pockets keep small items closed and organized.</li><li>Built-in ventilation lets your gear breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Dimensions: 48cm L x 23cm W x 23cm H (approx.)</li><li>31L</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li><li>Color Shown: Black/Black/Enigma Stone</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Utility Speed Backpack',
                    'category'         => 15,
                    'brand'            => 4,
                    'buying_price'     => 130,
                    'selling_price'    => 150,
                    'variation_price'  => 150,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>The Nike Utility Power Duffel Bag keeps your gear secure and ready for use while commuting to and from training sessions. Multiple pockets organize your essentials, while several handles offer versatile carrying options.</p><p><br></p><p>Secure Storage</p><p>The zipped main pocket provides easy access and loading. The internal sleeve helps keep small items in place and organized.</p><p><br></p><p>Built to Last</p><p>Durable construction helps keep your cargo safe when you're on the move.</p><p><br></p><p>Easy to Carry</p><p>An adjustable shoulder strap and dual handles give you comfortable carrying options.</p><p><br></p><p>Benefits</p><ul><li>Zipped exterior pockets keep small items closed and organized.</li><li>Built-in ventilation lets your gear breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Dimensions: 48cm L x 23cm W x 23cm H (approx.)</li><li>31L</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li><li>Color Shown: Black/Black/Enigma Stone</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Utility Speed Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>The Nike Utility Power Duffel Bag keeps your gear secure and ready for use while commuting to and from training sessions. Multiple pockets organize your essentials, while several handles offer versatile carrying options.</p><p><br></p><p>Secure Storage</p><p>The zipped main pocket provides easy access and loading. The internal sleeve helps keep small items in place and organized.</p><p><br></p><p>Built to Last</p><p>Durable construction helps keep your cargo safe when you're on the move.</p><p><br></p><p>Easy to Carry</p><p>An adjustable shoulder strap and dual handles give you comfortable carrying options.</p><p><br></p><p>Benefits</p><ul><li>Zipped exterior pockets keep small items closed and organized.</li><li>Built-in ventilation lets your gear breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Dimensions: 48cm L x 23cm W x 23cm H (approx.)</li><li>31L</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li><li>Color Shown: Black/Black/Enigma Stone</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Essential Dad Hat',
                    'category'         => 16,
                    'brand'            => 5,
                    'buying_price'     => 50,
                    'selling_price'    => 60,
                    'variation_price'  => 60,
                    'purchasable'      => Ask::NO,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Few garments evoke nostalgia for the 2000s more than the trucker hat. The mesh panels and bold branding on this Adidas one really cement it in the era. The snapback closure ensures an ideal fit since comfort is key to any laid-back style.</p><p><br></p><p>Product Details</p><ul><li>One size fits most</li><li>60% cotton, 40% polyester</li><li>Low, pre-curved brim</li><li>Mid-high crown</li><li>Mesh back panels</li><li>Snapback closure</li><li>Embroidered Trefoil logo</li><li>Imported</li><li>Product color: Black</li><li>Product code: EY5034</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Essential Dad Hat',
                    'meta_keyword' => ['Hat', 'Beanies'],
                    'description'  => "<p>Few garments evoke nostalgia for the 2000s more than the trucker hat. The mesh panels and bold branding on this Adidas one really cement it in the era. The snapback closure ensures an ideal fit since comfort is key to any laid-back style.</p><p><br></p><p>Product Details</p><ul><li>One size fits most</li><li>60% cotton, 40% polyester</li><li>Low, pre-curved brim</li><li>Mid-high crown</li><li>Mesh back panels</li><li>Snapback closure</li><li>Embroidered Trefoil logo</li><li>Imported</li><li>Product color: Black</li><li>Product code: EY5034</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Hat', 'Beanies'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Ultimate Hat',
                    'category'         => 16,
                    'brand'            => 6,
                    'buying_price'     => 50,
                    'selling_price'    => 65,
                    'variation_price'  => 65,
                    'purchasable'      => Ask::NO,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Few garments evoke nostalgia for the 2000s more than the trucker hat. The mesh panels and bold branding on this Adidas one really cement it in the era. The snapback closure ensures an ideal fit since comfort is key to any laid-back style.</p><p><br></p><p>Product Details</p><ul><li>One size fits most</li><li>60% cotton, 40% polyester</li><li>Low, pre-curved brim</li><li>Mid-high crown</li><li>Mesh back panels</li><li>Snapback closure</li><li>Embroidered Trefoil logo</li><li>Imported</li><li>Product color: Black</li><li>Product code: EY5034</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Ultimate Hat',
                    'meta_keyword' => ['Hat', 'Beanies'],
                    'description'  => "<p>Few garments evoke nostalgia for the 2000s more than the trucker hat. The mesh panels and bold branding on this Adidas one really cement it in the era. The snapback closure ensures an ideal fit since comfort is key to any laid-back style.</p><p><br></p><p>Product Details</p><ul><li>One size fits most</li><li>60% cotton, 40% polyester</li><li>Low, pre-curved brim</li><li>Mid-high crown</li><li>Mesh back panels</li><li>Snapback closure</li><li>Embroidered Trefoil logo</li><li>Imported</li><li>Product color: Black</li><li>Product code: EY5034</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Hat', 'Beanies'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Unisex Bucket Hat',
                    'category'         => 16,
                    'brand'            => 7,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Few garments evoke nostalgia for the 2000s more than the trucker hat. The mesh panels and bold branding on this Adidas one really cement it in the era. The snapback closure ensures an ideal fit since comfort is key to any laid-back style.</p><p><br></p><p>Product Details</p><ul><li>One size fits most</li><li>60% cotton, 40% polyester</li><li>Low, pre-curved brim</li><li>Mid-high crown</li><li>Mesh back panels</li><li>Snapback closure</li><li>Embroidered Trefoil logo</li><li>Imported</li><li>Product color: Black</li><li>Product code: EY5034</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Unisex Bucket Hat',
                    'meta_keyword' => ['Hat', 'Beanies'],
                    'description'  => "<p>Few garments evoke nostalgia for the 2000s more than the trucker hat. The mesh panels and bold branding on this Adidas one really cement it in the era. The snapback closure ensures an ideal fit since comfort is key to any laid-back style.</p><p><br></p><p>Product Details</p><ul><li>One size fits most</li><li>60% cotton, 40% polyester</li><li>Low, pre-curved brim</li><li>Mid-high crown</li><li>Mesh back panels</li><li>Snapback closure</li><li>Embroidered Trefoil logo</li><li>Imported</li><li>Product color: Black</li><li>Product code: EY5034</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Hat', 'Beanies'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Athletic Socks',
                    'category'         => 17,
                    'brand'            => 8,
                    'buying_price'     => 20,
                    'selling_price'    => 25,
                    'variation_price'  => 25,
                    'purchasable'      => Ask::NO,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Built tough for heavy training, these men's socks have full-length cushioning and a reinforced toe and heel. This ensures your feet stay dry from warm-up to cool-down.</p><p><br></p><p>Product Details</p><ul><li>Six pairs per pack</li><li>climalite® fabric sweeps sweat away from your skin</li><li>Engineered Adidas Badge of Sport on cuff</li><li>Reinforced heel and toe for durability</li><li>Arch compression</li><li>97% polyester, 3% elastane</li><li>Imported</li><li>Product color: White / Black</li><li>Product code: 101641</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Athletic Socks',
                    'meta_keyword' => ['Socks'],
                    'description'  => "<p>Built tough for heavy training, these men's socks have full-length cushioning and a reinforced toe and heel. This ensures your feet stay dry from warm-up to cool-down.</p><p><br></p><p>Product Details</p><ul><li>Six pairs per pack</li><li>climalite® fabric sweeps sweat away from your skin</li><li>Engineered Adidas Badge of Sport on cuff</li><li>Reinforced heel and toe for durability</li><li>Arch compression</li><li>97% polyester, 3% elastane</li><li>Imported</li><li>Product color: White / Black</li><li>Product code: 101641</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Socks'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Super Light Socks',
                    'category'         => 17,
                    'brand'            => 1,
                    'buying_price'     => 25,
                    'selling_price'    => 30,
                    'variation_price'  => 30,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Built tough for heavy training, these men's socks have full-length cushioning and a reinforced toe and heel. This ensures your feet stay dry from warm-up to cool-down.</p><p><br></p><p>Product Details</p><ul><li>Six pairs per pack</li><li>climalite® fabric sweeps sweat away from your skin</li><li>Engineered Adidas Badge of Sport on cuff</li><li>Reinforced heel and toe for durability</li><li>Arch compression</li><li>97% polyester, 3% elastane</li><li>Imported</li><li>Product color: White / Black</li><li>Product code: 101641</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Super Light Socks',
                    'meta_keyword' => ['Socks'],
                    'description'  => "<p>Built tough for heavy training, these men's socks have full-length cushioning and a reinforced toe and heel. This ensures your feet stay dry from warm-up to cool-down.</p><p><br></p><p>Product Details</p><ul><li>Six pairs per pack</li><li>climalite® fabric sweeps sweat away from your skin</li><li>Engineered Adidas Badge of Sport on cuff</li><li>Reinforced heel and toe for durability</li><li>Arch compression</li><li>97% polyester, 3% elastane</li><li>Imported</li><li>Product color: White / Black</li><li>Product code: 101641</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Socks'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Performance Boxer',
                    'category'         => 18,
                    'brand'            => 2,
                    'buying_price'     => 40,
                    'selling_price'    => 50,
                    'variation_price'  => 50,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Comfort starts with the layers you can't see. These Adidas boxer briefs hug your body with a soft cotton blend. Run, walk, and move through your day with unrestricted freedom. Enjoy the benefit of support with a comfortable fit that lets you forget you even have these boxers on.</p><p><br></p><ul><li>Product Details</li><li>95% cotton, 5% elastane</li><li>Stretch fabric</li><li>Four-pack of boxer briefs</li><li>Elastic waist</li><li>No-gap fly</li><li>No-ride-up construction</li><li>Imported</li><li>Product color: Burgundy</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Performance Boxer',
                    'meta_keyword' => ['Underwear'],
                    'description'  => "<p>Comfort starts with the layers you can't see. These Adidas boxer briefs hug your body with a soft cotton blend. Run, walk, and move through your day with unrestricted freedom. Enjoy the benefit of support with a comfortable fit that lets you forget you even have these boxers on.</p><p><br></p><ul><li>Product Details</li><li>95% cotton, 5% elastane</li><li>Stretch fabric</li><li>Four-pack of boxer briefs</li><li>Elastic waist</li><li>No-gap fly</li><li>No-ride-up construction</li><li>Imported</li><li>Product color: Burgundy</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Underwear'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Stretch Premium Boxer',
                    'category'         => 18,
                    'brand'            => 3,
                    'buying_price'     => 50,
                    'selling_price'    => 60,
                    'variation_price'  => 60,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Comfort starts with the layers you can't see. These Adidas boxer briefs hug your body with a soft cotton blend. Run, walk, and move through your day with unrestricted freedom. Enjoy the benefit of support with a comfortable fit that lets you forget you even have these boxers on.</p><p><br></p><ul><li>Product Details</li><li>95% cotton, 5% elastane</li><li>Stretch fabric</li><li>Four-pack of boxer briefs</li><li>Elastic waist</li><li>No-gap fly</li><li>No-ride-up construction</li><li>Imported</li><li>Product color: Burgundy</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Stretch Premium Boxer',
                    'meta_keyword' => ['Underwear'],
                    'description'  => "<p>Comfort starts with the layers you can't see. These Adidas boxer briefs hug your body with a soft cotton blend. Run, walk, and move through your day with unrestricted freedom. Enjoy the benefit of support with a comfortable fit that lets you forget you even have these boxers on.</p><p><br></p><ul><li>Product Details</li><li>95% cotton, 5% elastane</li><li>Stretch fabric</li><li>Four-pack of boxer briefs</li><li>Elastic waist</li><li>No-gap fly</li><li>No-ride-up construction</li><li>Imported</li><li>Product color: Burgundy</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Underwear'],
                'image_path' => 'men/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Long Skirt',
                    'category'         => 21,
                    'brand'            => 4,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Few things are more timeless than a monogram. This Adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Long Skirt',
                    'meta_keyword' => ['Dresses', 'Skirts'],
                    'description'  => "<p>Few things are more timeless than a monogram. This Adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Dresses', 'Skirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Summer Dress',
                    'category'         => 21,
                    'brand'            => 5,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Few things are more timeless than a monogram. This Adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Summer Dress',
                    'meta_keyword' => ['Dresses', 'Skirts'],
                    'description'  => "<p>Few things are more timeless than a monogram. This Adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Dresses', 'Skirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Queen Cover Up Dress',
                    'category'         => 21,
                    'brand'            => 6,
                    'buying_price'     => 140,
                    'selling_price'    => 150,
                    'variation_price'  => 150,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Few things are more timeless than a monogram. This Adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Queen Cover Up Dress',
                    'meta_keyword' => ['Dresses', 'Skirts'],
                    'description'  => "<p>Few things are more timeless than a monogram. This Adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Dresses', 'Skirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Phoenix Fleece',
                    'category'         => 22,
                    'brand'            => 7,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Phoenix Fleece',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Jordan Flight',
                    'category'         => 22,
                    'brand'            => 8,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Jordan Flight',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Gorgeous Sports Wear',
                    'category'         => 22,
                    'brand'            => 8,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Gorgeous Sports Wear',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Essential Hoodie',
                    'category'         => 22,
                    'brand'            => 1,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Essential Hoodie',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Even in a sweatshirt, your style is clear. Consider this Adidas pullover your foundation for expression, and definitely for comfort. Mix up the vibe with denim or wide-leg pants, or keep it head-to-toe casual with matching sweatpants for an elevated take on loungewear. Soft fleece launches you straight into a mode of relaxation.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>70% cotton, 30% recycled polyester fleece</li><li>Cozy feel</li><li>Ribbed cuffs and hem</li><li>Made with Better Cotton</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Black Jeans',
                    'category'         => 23,
                    'brand'            => 2,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Few things are more timeless than a monogram. This adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Black Jeans',
                    'meta_keyword' => ['Pants'],
                    'description'  => "<p>Few things are more timeless than a monogram. This adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Pants'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Denim Jeans',
                    'category'         => 23,
                    'brand'            => 3,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Few things are more timeless than a monogram. This adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Denim Jeans',
                    'meta_keyword' => ['Pants'],
                    'description'  => "<p>Few things are more timeless than a monogram. This adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Pants'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Navy Blue Jeans',
                    'category'         => 23,
                    'brand'            => 4,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Few things are more timeless than a monogram. This adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Navy Blue Jeans',
                    'meta_keyword' => ['Pants'],
                    'description'  => "<p>Few things are more timeless than a monogram. This adidas skirt elevates casual style with an allover Trefoil monogram print for a luxe look that's always on-trend. Cut from soft interlock fabric for a lightweight feel and a relaxed fit, it pairs easily with your favorite sneakers or a classic tee.</p><p><br></p><p>Product Details</p><ul><li>Drawcord on elastic waist</li><li>79% recycled polyester, 21% elastane interlock</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Pants'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'DailyRun Leggings',
                    'category'         => 24,
                    'brand'            => 5,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>From Goddess pose to Reclined Cobbler's pose, breathe through all your prenatal yoga moves in these Adidas maternity tights. Soft, lightweight fabric gives them a barely there feel. The very high waistband has a fold-over option for times when you're overheated. Fewer seams offer a distraction-free fit and AEROREADY absorbs moisture because you've got enough on your mind.</p><p><br></p><p>Product Details</p><ul><li>Tight fit with super-high rise</li><li>Stretch waist with fold-over option</li><li>73% recycled polyester, 27% elastane interlock</li><li>Light and soft fabric with comfortable stretch</li><li>AEROREADY</li><li>Minimal seaming</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'DailyRun Leggings',
                    'meta_keyword' => ['Tights', 'Leggings'],
                    'description'  => "<p>From Goddess pose to Reclined Cobbler's pose, breathe through all your prenatal yoga moves in these Adidas maternity tights. Soft, lightweight fabric gives them a barely there feel. The very high waistband has a fold-over option for times when you're overheated. Fewer seams offer a distraction-free fit and AEROREADY absorbs moisture because you've got enough on your mind.</p><p><br></p><p>Product Details</p><ul><li>Tight fit with super-high rise</li><li>Stretch waist with fold-over option</li><li>73% recycled polyester, 27% elastane interlock</li><li>Light and soft fabric with comfortable stretch</li><li>AEROREADY</li><li>Minimal seaming</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Tights', 'Leggings'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Techfit Leggings',
                    'category'         => 24,
                    'brand'            => 6,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>From Goddess pose to Reclined Cobbler's pose, breathe through all your prenatal yoga moves in these Adidas maternity tights. Soft, lightweight fabric gives them a barely there feel. The very high waistband has a fold-over option for times when you're overheated. Fewer seams offer a distraction-free fit and AEROREADY absorbs moisture because you've got enough on your mind.</p><p><br></p><p>Product Details</p><ul><li>Tight fit with super-high rise</li><li>Stretch waist with fold-over option</li><li>73% recycled polyester, 27% elastane interlock</li><li>Light and soft fabric with comfortable stretch</li><li>AEROREADY</li><li>Minimal seaming</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Techfit Leggings',
                    'meta_keyword' => ['Tights', 'Leggings'],
                    'description'  => "<p>From Goddess pose to Reclined Cobbler's pose, breathe through all your prenatal yoga moves in these Adidas maternity tights. Soft, lightweight fabric gives them a barely there feel. The very high waistband has a fold-over option for times when you're overheated. Fewer seams offer a distraction-free fit and AEROREADY absorbs moisture because you've got enough on your mind.</p><p><br></p><p>Product Details</p><ul><li>Tight fit with super-high rise</li><li>Stretch waist with fold-over option</li><li>73% recycled polyester, 27% elastane interlock</li><li>Light and soft fabric with comfortable stretch</li><li>AEROREADY</li><li>Minimal seaming</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Tights', 'Leggings'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Yoga Studio 34 Leggings',
                    'category'         => 24,
                    'brand'            => 7,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>From Goddess pose to Reclined Cobbler's pose, breathe through all your prenatal yoga moves in these Adidas maternity tights. Soft, lightweight fabric gives them a barely there feel. The very high waistband has a fold-over option for times when you're overheated. Fewer seams offer a distraction-free fit and AEROREADY absorbs moisture because you've got enough on your mind.</p><p><br></p><p>Product Details</p><ul><li>Tight fit with super-high rise</li><li>Stretch waist with fold-over option</li><li>73% recycled polyester, 27% elastane interlock</li><li>Light and soft fabric with comfortable stretch</li><li>AEROREADY</li><li>Minimal seaming</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Yoga Studio 34 Leggings',
                    'meta_keyword' => ['Tights', 'Leggings'],
                    'description'  => "<p>From Goddess pose to Reclined Cobbler's pose, breathe through all your prenatal yoga moves in these Adidas maternity tights. Soft, lightweight fabric gives them a barely there feel. The very high waistband has a fold-over option for times when you're overheated. Fewer seams offer a distraction-free fit and AEROREADY absorbs moisture because you've got enough on your mind.</p><p><br></p><p>Product Details</p><ul><li>Tight fit with super-high rise</li><li>Stretch waist with fold-over option</li><li>73% recycled polyester, 27% elastane interlock</li><li>Light and soft fabric with comfortable stretch</li><li>AEROREADY</li><li>Minimal seaming</li><li>Imported</li></ul>",
                ],
                'taxes'      => [4],
                'tags'       => ['Tights', 'Leggings'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Trefoil',
                    'category'         => 25,
                    'brand'            => 8,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'seo'        => [
                    'title'        => 'Classic Trefoil',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-fit Crop Top',
                    'category'         => 25,
                    'brand'            => 1,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'seo'        => [
                    'title'        => 'Dri-fit Crop Top',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Gorgeous Tops',
                    'category'         => 25,
                    'brand'            => 2,
                    'buying_price'     => 110,
                    'selling_price'    => 130,
                    'variation_price'  => 130,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'seo'        => [
                    'title'        => 'Gorgeous Tops',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Regular Essential Tee',
                    'category'         => 25,
                    'brand'            => 3,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'seo'        => [
                    'title'        => 'Regular Essential Tee',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>Embrace a sporty, casual vibe with this cropped Adicolor t-shirt. The loose fit lets you mix and match to layer while the soft cotton single jersey build keeps you comfortable. An oversized Trefoil logo on the front gives a not-so-subtle nod to Adidas heritage.</p><p><br></p><p>Product Details</p><ul><li>Loose fit</li><li>Ribbed crewneck</li><li>100% cotton single jersey</li><li>Made with Better Cotton</li><li>Imported</li></ul><p><br></p>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'women/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Pegasus 40',
                    'category'         => 27,
                    'brand'            => 4,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Pegasus 40',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Running'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'React Infinity 13',
                    'category'         => 27,
                    'brand'            => 5,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'React Infinity 13',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Running'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Vomero 16',
                    'category'         => 27,
                    'brand'            => 5,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Vomero 16',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Running'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'ZoomX Dragonfly',
                    'category'         => 27,
                    'brand'            => 6,
                    'buying_price'     => 160,
                    'selling_price'    => 180,
                    'variation_price'  => 180,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'ZoomX Dragonfly',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards, and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Running'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Air Force 1 Shadow',
                    'category'         => 28,
                    'brand'            => 7,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Air Force 1 Shadow',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Sneakers'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Jordan 1 Elevate Low',
                    'category'         => 28,
                    'brand'            => 8,
                    'buying_price'     => 160,
                    'selling_price'    => 180,
                    'variation_price'  => 180,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Jordan 1 Elevate Low',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Sneakers'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Jordan 1 Low SE',
                    'category'         => 28,
                    'brand'            => 1,
                    'buying_price'     => 180,
                    'selling_price'    => 200,
                    'variation_price'  => 200,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Jordan 1 Low SE',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Sneakers'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Nike Dunk Low',
                    'category'         => 28,
                    'brand'            => 2,
                    'buying_price'     => 200,
                    'selling_price'    => 220,
                    'variation_price'  => 220,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Nike Dunk Low',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Sneakers'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Free Metcon 5',
                    'category'         => 29,
                    'brand'            => 3,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Free Metcon 5',
                    'meta_keyword' => ['Training', 'Gym'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Training', 'Gym'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'In Season TR 13',
                    'category'         => 29,
                    'brand'            => 4,
                    'buying_price'     => 160,
                    'selling_price'    => 180,
                    'variation_price'  => 180,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'In Season TR 13',
                    'meta_keyword' => ['Training', 'Gym'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Training', 'Gym'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Zoom SuperRep 4',
                    'category'         => 29,
                    'brand'            => 5,
                    'buying_price'     => 180,
                    'selling_price'    => 200,
                    'variation_price'  => 200,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Zoom SuperRep 4',
                    'meta_keyword' => ['Training', 'Gym'],
                    'description'  => "<p>Make every step unique. These kicks put a playful twist on a hoops icon by doubling up on everything you love about the AF-1. Layered materials like linen-evoking textiles and synthetic leather pair with an exaggerated midsole and a pop of pastels to bring you double the style.</p><p><br></p><p>Benefits</p><ul><li>With 2 eye stays, 2 mudguards and 2 Swoosh logos, you get a layered aesthetic with double the branding.</li><li>Stitched leather overlays add durability and texture to the heritage look.</li><li>Originally designed for performance hoops, the Nike Air cushioning adds lasting comfort.</li></ul><p><br></p><p>Product Details</p><ul><li>Foam midsole</li><li>Color Shown: Sail/Sea Coral/Indigo Haze/Coral Chalk</li><li>Style: DV7449-101</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Training', 'Gym'],
                'image_path' => 'women/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Classic Stripe-3 Backpack',
                    'category'         => 31,
                    'brand'            => 6,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Classic Stripe-3 Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Excel Backpack',
                    'category'         => 31,
                    'brand'            => 7,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Excel Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Favourint Backpack',
                    'category'         => 31,
                    'brand'            => 8,
                    'buying_price'     => 160,
                    'selling_price'    => 180,
                    'variation_price'  => 180,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Favourint Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Graphic Backpack',
                    'category'         => 31,
                    'brand'            => 1,
                    'buying_price'     => 180,
                    'selling_price'    => 200,
                    'variation_price'  => 200,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Graphic Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>This Adidas backpack is ready for anything. Just like you. Workday? No problem, there's a laptop pocket to stow your computer. Time to play? The side slip-in pockets are perfect for holding all the other items you need as you explore around town or catch a train to an exciting destination.</p><p><br></p><p>Product Details</p><ul><li>Dimensions: 17.3\" x 11.4\" x 6.7\"</li><li>Volume: 20.5 L</li><li>100% recycled polyester plain knit</li><li>Side slip-in pockets</li><li>Laptop pocket</li><li>Air mesh back panel</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Essential Hat',
                    'category'         => 32,
                    'brand'            => 2,
                    'buying_price'     => 40,
                    'selling_price'    => 60,
                    'variation_price'  => 60,
                    'purchasable'      => Ask::NO,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Keep your competitive edge from first tee to final putt in this Adidas golf hat. The five-panel construction fits close for undistracted play. An adjustable snapback closure lets you fine-tune the fit.</p><p><br></p><p>Details</p><ul><li>One size fits most</li><li>97% recycled polyester, 3% elastane plain weave</li><li>Pre-curved brim</li><li>Adjustable snapback closure</li><li>Five-panel construction</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Essential Hat',
                    'meta_keyword' => ['Hats'],
                    'description'  => "<p>Keep your competitive edge from first tee to final putt in this Adidas golf hat. The five-panel construction fits close for undistracted play. An adjustable snapback closure lets you fine-tune the fit.</p><p><br></p><p>Details</p><ul><li>One size fits most</li><li>97% recycled polyester, 3% elastane plain weave</li><li>Pre-curved brim</li><li>Adjustable snapback closure</li><li>Five-panel construction</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Hats'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Season Opener Hat',
                    'category'         => 32,
                    'brand'            => 3,
                    'buying_price'     => 50,
                    'selling_price'    => 70,
                    'variation_price'  => 70,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Keep your competitive edge from first tee to final putt in this Adidas golf hat. The five-panel construction fits close for undistracted play. An adjustable snapback closure lets you fine-tune the fit.</p><p><br></p><p>Details</p><ul><li>One size fits most</li><li>97% recycled polyester, 3% elastane plain weave</li><li>Pre-curved brim</li><li>Adjustable snapback closure</li><li>Five-panel construction</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Season Opener Hat',
                    'meta_keyword' => ['Hats'],
                    'description'  => "<p>Keep your competitive edge from first tee to final putt in this Adidas golf hat. The five-panel construction fits close for undistracted play. An adjustable snapback closure lets you fine-tune the fit.</p><p><br></p><p>Details</p><ul><li>One size fits most</li><li>97% recycled polyester, 3% elastane plain weave</li><li>Pre-curved brim</li><li>Adjustable snapback closure</li><li>Five-panel construction</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Hats'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Utility Boonie Hat',
                    'category'         => 32,
                    'brand'            => 2,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Keep your competitive edge from first tee to final putt in this Adidas golf hat. The five-panel construction fits close for undistracted play. An adjustable snapback closure lets you fine-tune the fit.</p><p><br></p><p>Details</p><ul><li>One size fits most</li><li>97% recycled polyester, 3% elastane plain weave</li><li>Pre-curved brim</li><li>Adjustable snapback closure</li><li>Five-panel construction</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Utility Boonie Hat',
                    'meta_keyword' => ['Hats'],
                    'description'  => "<p>Keep your competitive edge from first tee to final putt in this Adidas golf hat. The five-panel construction fits close for undistracted play. An adjustable snapback closure lets you fine-tune the fit.</p><p><br></p><p>Details</p><ul><li>One size fits most</li><li>97% recycled polyester, 3% elastane plain weave</li><li>Pre-curved brim</li><li>Adjustable snapback closure</li><li>Five-panel construction</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Hats'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Everyday Plus',
                    'category'         => 33,
                    'brand'            => 3,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::NO,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Work out for the frill of it. Combining soft yarns with sweat-wicking power, these scrunched-cuff socks help keep your feet dry and comfortable during your training sessions without sacrificing style.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT Technology helps keep your feet dry and comfortable.</li><li>Knit yarns feel soft against your feet.</li></ul><p><br></p><p>Product Details</p><ul><li>85% polyester/13% nylon/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Everyday Plus',
                    'meta_keyword' => ['Socks'],
                    'description'  => "<p>Work out for the frill of it. Combining soft yarns with sweat-wicking power, these scrunched-cuff socks help keep your feet dry and comfortable during your training sessions without sacrificing style.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT Technology helps keep your feet dry and comfortable.</li><li>Knit yarns feel soft against your feet.</li></ul><p><br></p><p>Product Details</p><ul><li>85% polyester/13% nylon/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Socks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Everyday Premium',
                    'category'         => 33,
                    'brand'            => 4,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Work out for the frill of it. Combining soft yarns with sweat-wicking power, these scrunched-cuff socks help keep your feet dry and comfortable during your training sessions without sacrificing style.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT Technology helps keep your feet dry and comfortable.</li><li>Knit yarns feel soft against your feet.</li></ul><p><br></p><p>Product Details</p><ul><li>85% polyester/13% nylon/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Everyday Premium',
                    'meta_keyword' => ['Socks'],
                    'description'  => "<p>Work out for the frill of it. Combining soft yarns with sweat-wicking power, these scrunched-cuff socks help keep your feet dry and comfortable during your training sessions without sacrificing style.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT Technology helps keep your feet dry and comfortable.</li><li>Knit yarns feel soft against your feet.</li></ul><p><br></p><p>Product Details</p><ul><li>85% polyester/13% nylon/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Socks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Everyday Pro',
                    'category'         => 33,
                    'brand'            => 5,
                    'buying_price'     => 40,
                    'selling_price'    => 60,
                    'variation_price'  => 60,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Work out for the frill of it. Combining soft yarns with sweat-wicking power, these scrunched-cuff socks help keep your feet dry and comfortable during your training sessions without sacrificing style.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT Technology helps keep your feet dry and comfortable.</li><li>Knit yarns feel soft against your feet.</li></ul><p><br></p><p>Product Details</p><ul><li>85% polyester/13% nylon/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Everyday Pro',
                    'meta_keyword' => ['Socks'],
                    'description'  => "<p>Work out for the frill of it. Combining soft yarns with sweat-wicking power, these scrunched-cuff socks help keep your feet dry and comfortable during your training sessions without sacrificing style.</p><p><br></p><p>Benefits</p><ul><li>Dri-FIT Technology helps keep your feet dry and comfortable.</li><li>Knit yarns feel soft against your feet.</li></ul><p><br></p><p>Product Details</p><ul><li>85% polyester/13% nylon/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Socks'],
                'image_path' => 'women/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Air Hoodie',
                    'category'         => 36,
                    'brand'            => 6,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Air Hoodie',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Air Sweatshirt',
                    'category'         => 36,
                    'brand'            => 7,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Air Sweatshirt',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Camo Hoodie',
                    'category'         => 36,
                    'brand'            => 8,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Camo Hoodie',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Squad Big Kid Hoodie',
                    'category'         => 36,
                    'brand'            => 1,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Squad Big Kid Hoodie',
                    'meta_keyword' => ['Hoodies', 'Sweatshirts'],
                    'description'  => "<p>Sweatshirt gives a boost to your everyday cool-weather wear. From the fuzzy inside to reflective-design details and BIG Air graphics, this super-soft fleece layer can be put on in a flash and shows everyone who you're repping.</p><p><br></p><p>Benefits</p><ul><li>Super-soft fleece has a fluffy feel against your body for extra warmth.</li><li>Ribbed cuffs, hem, and crew neck help keep your fit in place.</li></ul><p><br></p><p>Product Details</p><ul><li>Standard fit for a relaxed, easy feel</li><li>Reflective design details</li><li>Body: 80% cotton/20% polyester. Rib: 98% cotton/2% elastane.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Hoodies', 'Sweatshirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Basketball Jaws Short',
                    'category'         => 37,
                    'brand'            => 2,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Basketball Jaws Short',
                    'meta_keyword' => ['Shorts'],
                    'description'  => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Shorts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-Fit One',
                    'category'         => 37,
                    'brand'            => 3,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dri-Fit One',
                    'meta_keyword' => ['Shorts'],
                    'description'  => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Shorts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Entrada 22 Shorts',
                    'category'         => 37,
                    'brand'            => 4,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Entrada 22 Shorts',
                    'meta_keyword' => ['Shorts'],
                    'description'  => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Shorts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Sportswear Club Fleece',
                    'category'         => 37,
                    'brand'            => 5,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Sportswear Club Fleece',
                    'meta_keyword' => ['Shorts'],
                    'description'  => "<p>Move in Comfort</p><p>A mid-rise stretchy waistband and V-shaped back panel follow your body's natural lines so you can stretch, stride, and climb confidently.</p><p><br></p><p>Hidden Pocket</p><p>A secret pocket inside the back waistband lets you store a small essential—like a lip balm, a key, or a card.</p><p><br></p><p>Product Details</p><ul><li>18cm (approx.) inseam</li><li>Body: 83% polyester/17% elastane. Gusset Lining: 100% polyester.</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Shorts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-fit Trefoil Tee',
                    'category'         => 38,
                    'brand'            => 6,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dri-fit Trefoil Tee',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Graphic Print Tee',
                    'category'         => 38,
                    'brand'            => 7,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Graphic Print Tee',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Tiro Tee Kids',
                    'category'         => 38,
                    'brand'            => 8,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Tiro Tee Kids',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Trefoil Tee',
                    'category'         => 38,
                    'brand'            => 1,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Trefoil Tee',
                    'meta_keyword' => ['Tops', 'T-shirts'],
                    'description'  => "<p>A new season calls for new gear to play your favorite sports—or just for fun outside. Get started with the Nike Dri-FIT Multi+ active top. It's lightweight, breathable, and helps sweat stay away. Stock up! How many colors do you want them in?</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Standard fit is your classic fit—meaning it's not too loose or tight.</li><li>Soft knit fabric is lightweight and breathable.</li><li>The ribbed collar stretches to easily get the top on and off.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>Machine wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [3, 4],
                'tags'       => ['Tops', 'T-shirts'],
                'image_path' => 'juniors/clothing',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Forum Low Shoes Kids',
                    'category'         => 40,
                    'brand'            => 2,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Gear up in Jordan heritage. With details drawn from decades of shoes, the Stay Loyal 2 is a collage of cool. Mesh and leather upper give you stability without worrying about weighing you down. Air in the heel keeps you cushioned. Get out and play!</p><p><br></p><p>Benefits</p><ul><li>Nike Air technology absorbs impact for cushioning with every step.</li><li>The leather upper breaks in easily and makes for a long-lasting shoe.</li><li>Knit mesh toe lets your feet breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Jumpman logo heel band</li><li>Heel loop</li><li>Moulded eyelet detail</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Forum Low Shoes Kids',
                    'meta_keyword' => ['Basketball'],
                    'description'  => "<p>Gear up in Jordan heritage. With details drawn from decades of shoes, the Stay Loyal 2 is a collage of cool. Mesh and leather upper give you stability without worrying about weighing you down. Air in the heel keeps you cushioned. Get out and play!</p><p><br></p><p>Benefits</p><ul><li>Nike Air technology absorbs impact for cushioning with every step.</li><li>The leather upper breaks in easily and makes for a long-lasting shoe.</li><li>Knit mesh toe lets your feet breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Jumpman logo heel band</li><li>Heel loop</li><li>Moulded eyelet detail</li></ul>",
                ],
                'taxes'      => [3],
                'tags'       => ['Basketball'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Jordan Stay Loyal 2',
                    'category'         => 40,
                    'brand'            => 3,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Gear up in Jordan heritage. With details drawn from decades of shoes, the Stay Loyal 2 is a collage of cool. Mesh and leather upper give you stability without worrying about weighing you down. Air in the heel keeps you cushioned. Get out and play!</p><p><br></p><p>Benefits</p><ul><li>Nike Air technology absorbs impact for cushioning with every step.</li><li>The leather upper breaks in easily and makes for a long-lasting shoe.</li><li>Knit mesh toe lets your feet breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Jumpman logo heel band</li><li>Heel loop</li><li>Moulded eyelet detail</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Jordan Stay Loyal 2',
                    'meta_keyword' => ['Basketball'],
                    'description'  => "<p>Gear up in Jordan heritage. With details drawn from decades of shoes, the Stay Loyal 2 is a collage of cool. Mesh and leather upper give you stability without worrying about weighing you down. Air in the heel keeps you cushioned. Get out and play!</p><p><br></p><p>Benefits</p><ul><li>Nike Air technology absorbs impact for cushioning with every step.</li><li>The leather upper breaks in easily and makes for a long-lasting shoe.</li><li>Knit mesh toe lets your feet breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Jumpman logo heel band</li><li>Heel loop</li><li>Moulded eyelet detail</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Basketball'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Nike Team Hustle D 11',
                    'category'         => 40,
                    'brand'            => 4,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Gear up in Jordan heritage. With details drawn from decades of shoes, the Stay Loyal 2 is a collage of cool. Mesh and leather upper give you stability without worrying about weighing you down. Air in the heel keeps you cushioned. Get out and play!</p><p><br></p><p>Benefits</p><ul><li>Nike Air technology absorbs impact for cushioning with every step.</li><li>The leather upper breaks in easily and makes for a long-lasting shoe.</li><li>Knit mesh toe lets your feet breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Jumpman logo heel band</li><li>Heel loop</li><li>Moulded eyelet detail</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Nike Team Hustle D 11',
                    'meta_keyword' => ['Basketball'],
                    'description'  => "<p>Gear up in Jordan heritage. With details drawn from decades of shoes, the Stay Loyal 2 is a collage of cool. Mesh and leather upper give you stability without worrying about weighing you down. Air in the heel keeps you cushioned. Get out and play!</p><p><br></p><p>Benefits</p><ul><li>Nike Air technology absorbs impact for cushioning with every step.</li><li>The leather upper breaks in easily and makes for a long-lasting shoe.</li><li>Knit mesh toe lets your feet breathe.</li></ul><p><br></p><p>Product Details</p><ul><li>Jumpman logo heel band</li><li>Heel loop</li><li>Moulded eyelet detail</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Basketball'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Nike Revolution 6',
                    'category'         => 41,
                    'brand'            => 5,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Easy Entry</p><p>Nike FlyEase technology makes it super simple to get these shoes on and off. A wraparound zip on the heel opens up the shoe and a strap over the top secures little feet in.</p><p><br></p><p>Cool Steps</p><p>Lightweight textile provides breathability so little feet can stay cool. A heel overlay offers support and stability for multi-directional moves.</p><p><br></p><p>Made to Move</p><p>Soft foam underfoot creates plush cushioning with every stride, plus a rubber sole gives durable traction.</p><p><br></p><p>Product Details</p><ul><li>Reinforced toe tip</li><li>FlyEase technology</li><li>Rubber outsole</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Nike Revolution 6',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Easy Entry</p><p>Nike FlyEase technology makes it super simple to get these shoes on and off. A wraparound zip on the heel opens up the shoe and a strap over the top secures little feet in.</p><p><br></p><p>Cool Steps</p><p>Lightweight textile provides breathability so little feet can stay cool. A heel overlay offers support and stability for multi-directional moves.</p><p><br></p><p>Made to Move</p><p>Soft foam underfoot creates plush cushioning with every stride, plus a rubber sole gives durable traction.</p><p><br></p><p>Product Details</p><ul><li>Reinforced toe tip</li><li>FlyEase technology</li><li>Rubber outsole</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Running'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Nike Revolution 6 FlyEase',
                    'category'         => 41,
                    'brand'            => 6,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Easy Entry</p><p>Nike FlyEase technology makes it super simple to get these shoes on and off. A wraparound zip on the heel opens up the shoe and a strap over the top secures little feet in.</p><p><br></p><p>Cool Steps</p><p>Lightweight textile provides breathability so little feet can stay cool. A heel overlay offers support and stability for multi-directional moves.</p><p><br></p><p>Made to Move</p><p>Soft foam underfoot creates plush cushioning with every stride, plus a rubber sole gives durable traction.</p><p><br></p><p>Product Details</p><ul><li>Reinforced toe tip</li><li>FlyEase technology</li><li>Rubber outsole</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Nike Revolution 6 FlyEase',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Easy Entry</p><p>Nike FlyEase technology makes it super simple to get these shoes on and off. A wraparound zip on the heel opens up the shoe and a strap over the top secures little feet in.</p><p><br></p><p>Cool Steps</p><p>Lightweight textile provides breathability so little feet can stay cool. A heel overlay offers support and stability for multi-directional moves.</p><p><br></p><p>Made to Move</p><p>Soft foam underfoot creates plush cushioning with every stride, plus a rubber sole gives durable traction.</p><p><br></p><p>Product Details</p><ul><li>Reinforced toe tip</li><li>FlyEase technology</li><li>Rubber outsole</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Running'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Ultra Bounce Shoes',
                    'category'         => 41,
                    'brand'            => 7,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Easy Entry</p><p>Nike FlyEase technology makes it super simple to get these shoes on and off. A wraparound zip on the heel opens up the shoe and a strap over the top secures little feet in.</p><p><br></p><p>Cool Steps</p><p>Lightweight textile provides breathability so little feet can stay cool. A heel overlay offers support and stability for multi-directional moves.</p><p><br></p><p>Made to Move</p><p>Soft foam underfoot creates plush cushioning with every stride, plus a rubber sole gives durable traction.</p><p><br></p><p>Product Details</p><ul><li>Reinforced toe tip</li><li>FlyEase technology</li><li>Rubber outsole</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Ultra Bounce Shoes',
                    'meta_keyword' => ['Running'],
                    'description'  => "<p>Easy Entry</p><p>Nike FlyEase technology makes it super simple to get these shoes on and off. A wraparound zip on the heel opens up the shoe and a strap over the top secures little feet in.</p><p><br></p><p>Cool Steps</p><p>Lightweight textile provides breathability so little feet can stay cool. A heel overlay offers support and stability for multi-directional moves.</p><p><br></p><p>Made to Move</p><p>Soft foam underfoot creates plush cushioning with every stride, plus a rubber sole gives durable traction.</p><p><br></p><p>Product Details</p><ul><li>Reinforced toe tip</li><li>FlyEase technology</li><li>Rubber outsole</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Running'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Air Jordan 1 Low',
                    'category'         => 42,
                    'brand'            => 8,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>An iconic look that lasts. This AJ1 pairs the classic design of the original with premium materials that will keep you going all day.</p><p><br></p><p>Benefits</p><ul><li>Real- and synthetic-leather upper delivers durable comfort.</li><li>The Nike Air unit in the heel creates lightweight, bouncy cushioning.</li><li>Flex grooves at the front of the outsole</li><li>Rubber outsole provides traction on a variety of surfaces.</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Air Jordan 1 Low',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>An iconic look that lasts. This AJ1 pairs the classic design of the original with premium materials that will keep you going all day.</p><p><br></p><p>Benefits</p><ul><li>Real- and synthetic-leather upper delivers durable comfort.</li><li>The Nike Air unit in the heel creates lightweight, bouncy cushioning.</li><li>Flex grooves at the front of the outsole</li><li>Rubber outsole provides traction on a variety of surfaces.</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Sneakers'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Gazelle Shoes Kids',
                    'category'         => 42,
                    'brand'            => 1,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>An iconic look that lasts. This AJ1 pairs the classic design of the original with premium materials that will keep you going all day.</p><p><br></p><p>Benefits</p><ul><li>Real- and synthetic-leather upper delivers durable comfort.</li><li>The Nike Air unit in the heel creates lightweight, bouncy cushioning.</li><li>Flex grooves at the front of the outsole</li><li>Rubber outsole provides traction on a variety of surfaces.</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Gazelle Shoes Kids',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>An iconic look that lasts. This AJ1 pairs the classic design of the original with premium materials that will keep you going all day.</p><p><br></p><p>Benefits</p><ul><li>Real- and synthetic-leather upper delivers durable comfort.</li><li>The Nike Air unit in the heel creates lightweight, bouncy cushioning.</li><li>Flex grooves at the front of the outsole</li><li>Rubber outsole provides traction on a variety of surfaces.</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Sneakers'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Jordan Retro 1 High',
                    'category'         => 42,
                    'brand'            => 2,
                    'buying_price'     => 140,
                    'selling_price'    => 160,
                    'variation_price'  => 160,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>An iconic look that lasts. This AJ1 pairs the classic design of the original with premium materials that will keep you going all day.</p><p><br></p><p>Benefits</p><ul><li>Real- and synthetic-leather upper delivers durable comfort.</li><li>The Nike Air unit in the heel creates lightweight, bouncy cushioning.</li><li>Flex grooves at the front of the outsole</li><li>Rubber outsole provides traction on a variety of surfaces.</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Jordan Retro 1 High',
                    'meta_keyword' => ['Sneakers'],
                    'description'  => "<p>An iconic look that lasts. This AJ1 pairs the classic design of the original with premium materials that will keep you going all day.</p><p><br></p><p>Benefits</p><ul><li>Real- and synthetic-leather upper delivers durable comfort.</li><li>The Nike Air unit in the heel creates lightweight, bouncy cushioning.</li><li>Flex grooves at the front of the outsole</li><li>Rubber outsole provides traction on a variety of surfaces.</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Sneakers'],
                'image_path' => 'juniors/shoes',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Graphic Backpack',
                    'category'         => 44,
                    'brand'            => 3,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Doing your best at school takes the right gear. The Nike Backpack helps you do just that, with its roomy main compartment to store all of your essentials and a separate zip front pocket to keep small stuff in place. Don't worry about pens and pencils rolling around and breaking in the bottom of this backpack—there's an attached pencil case to keep them secure.</p><p><br></p><p>Benefits</p><ul><li>Padded shoulder straps are adjustable for a comfortable fit.</li><li>The mesh side pocket holds a water bottle.</li><li>The haul loop gives you an alternative carrying option.</li><li>The attachable pencil case holds writing and school utensils.</li></ul><p><br></p><p>Product Details</p><ul><li>46cm H x 30cm W x 13cm D (approx.)</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Graphic Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>Doing your best at school takes the right gear. The Nike Backpack helps you do just that, with its roomy main compartment to store all of your essentials and a separate zip front pocket to keep small stuff in place. Don't worry about pens and pencils rolling around and breaking in the bottom of this backpack—there's an attached pencil case to keep them secure.</p><p><br></p><p>Benefits</p><ul><li>Padded shoulder straps are adjustable for a comfortable fit.</li><li>The mesh side pocket holds a water bottle.</li><li>The haul loop gives you an alternative carrying option.</li><li>The attachable pencil case holds writing and school utensils.</li></ul><p><br></p><p>Product Details</p><ul><li>46cm H x 30cm W x 13cm D (approx.)</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'juniors/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Kid’s Backpack',
                    'category'         => 44,
                    'brand'            => 4,
                    'buying_price'     => 100,
                    'selling_price'    => 120,
                    'variation_price'  => 120,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Doing your best at school takes the right gear. The Nike Backpack helps you do just that, with its roomy main compartment to store all of your essentials and a separate zip front pocket to keep small stuff in place. Don't worry about pens and pencils rolling around and breaking in the bottom of this backpack—there's an attached pencil case to keep them secure.</p><p><br></p><p>Benefits</p><ul><li>Padded shoulder straps are adjustable for a comfortable fit.</li><li>The mesh side pocket holds a water bottle.</li><li>The haul loop gives you an alternative carrying option.</li><li>The attachable pencil case holds writing and school utensils.</li></ul><p><br></p><p>Product Details</p><ul><li>46cm H x 30cm W x 13cm D (approx.)</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Kid’s Backpack',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>Doing your best at school takes the right gear. The Nike Backpack helps you do just that, with its roomy main compartment to store all of your essentials and a separate zip front pocket to keep small stuff in place. Don't worry about pens and pencils rolling around and breaking in the bottom of this backpack—there's an attached pencil case to keep them secure.</p><p><br></p><p>Benefits</p><ul><li>Padded shoulder straps are adjustable for a comfortable fit.</li><li>The mesh side pocket holds a water bottle.</li><li>The haul loop gives you an alternative carrying option.</li><li>The attachable pencil case holds writing and school utensils.</li></ul><p><br></p><p>Product Details</p><ul><li>46cm H x 30cm W x 13cm D (approx.)</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'juniors/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Nike Brasilia',
                    'category'         => 44,
                    'brand'            => 5,
                    'buying_price'     => 120,
                    'selling_price'    => 140,
                    'variation_price'  => 140,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Doing your best at school takes the right gear. The Nike Backpack helps you do just that, with its roomy main compartment to store all of your essentials and a separate zip front pocket to keep small stuff in place. Don't worry about pens and pencils rolling around and breaking in the bottom of this backpack—there's an attached pencil case to keep them secure.</p><p><br></p><p>Benefits</p><ul><li>Padded shoulder straps are adjustable for a comfortable fit.</li><li>The mesh side pocket holds a water bottle.</li><li>The haul loop gives you an alternative carrying option.</li><li>The attachable pencil case holds writing and school utensils.</li></ul><p><br></p><p>Product Details</p><ul><li>46cm H x 30cm W x 13cm D (approx.)</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Nike Brasilia',
                    'meta_keyword' => ['Bags', 'Backpacks'],
                    'description'  => "<p>Doing your best at school takes the right gear. The Nike Backpack helps you do just that, with its roomy main compartment to store all of your essentials and a separate zip front pocket to keep small stuff in place. Don't worry about pens and pencils rolling around and breaking in the bottom of this backpack—there's an attached pencil case to keep them secure.</p><p><br></p><p>Benefits</p><ul><li>Padded shoulder straps are adjustable for a comfortable fit.</li><li>The mesh side pocket holds a water bottle.</li><li>The haul loop gives you an alternative carrying option.</li><li>The attachable pencil case holds writing and school utensils.</li></ul><p><br></p><p>Product Details</p><ul><li>46cm H x 30cm W x 13cm D (approx.)</li><li>100% polyester</li><li>Spot clean</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Bags', 'Backpacks'],
                'image_path' => 'juniors/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Dri-Fit Club Hat',
                    'category'         => 45,
                    'brand'            => 6,
                    'buying_price'     => 40,
                    'selling_price'    => 60,
                    'variation_price'  => 60,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::NO,
                    'discount'         => 0,
                    'offer_start_date' => null,
                    'offer_end_date'   => null,
                    'description'      => "<p>Step your Swoosh game up with this mid-depth, unstructured Club Cap. Its curved bill and metal Swoosh logo give your look a clean finish while sweat-wicking tech helps you stay cool and comfortable while you make the most of warm, sunny weather.</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Twill fabric has a lightweight, smooth feel.</li><li>A mid-depth, 6-panel design makes for easy styling.</li><li>The Swoosh branded metal tri-glide lets you adjust your fit with ease.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>A metal Swoosh Ingot logo</li><li>An adjustable metal clamp closure with Embossed Swoosh</li><li>Hand-wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Dri-Fit Club Hat',
                    'meta_keyword' => ['Hats'],
                    'description'  => "<p>Step your Swoosh game up with this mid-depth, unstructured Club Cap. Its curved bill and metal Swoosh logo give your look a clean finish while sweat-wicking tech helps you stay cool and comfortable while you make the most of warm, sunny weather.</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Twill fabric has a lightweight, smooth feel.</li><li>A mid-depth, 6-panel design makes for easy styling.</li><li>The Swoosh branded metal tri-glide lets you adjust your fit with ease.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>A metal Swoosh Ingot logo</li><li>An adjustable metal clamp closure with Embossed Swoosh</li><li>Hand-wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2],
                'tags'       => ['Hats'],
                'image_path' => 'juniors/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Heritage 89',
                    'category'         => 45,
                    'brand'            => 7,
                    'buying_price'     => 60,
                    'selling_price'    => 80,
                    'variation_price'  => 80,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 20,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Step your Swoosh game up with this mid-depth, unstructured Club Cap. Its curved bill and metal Swoosh logo give your look a clean finish while sweat-wicking tech helps you stay cool and comfortable while you make the most of warm, sunny weather.</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Twill fabric has a lightweight, smooth feel.</li><li>A mid-depth, 6-panel design makes for easy styling.</li><li>The Swoosh branded metal tri-glide lets you adjust your fit with ease.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>A metal Swoosh Ingot logo</li><li>An adjustable metal clamp closure with Embossed Swoosh</li><li>Hand-wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Heritage 89',
                    'meta_keyword' => ['Hats'],
                    'description'  => "<p>Step your Swoosh game up with this mid-depth, unstructured Club Cap. Its curved bill and metal Swoosh logo give your look a clean finish while sweat-wicking tech helps you stay cool and comfortable while you make the most of warm, sunny weather.</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Twill fabric has a lightweight, smooth feel.</li><li>A mid-depth, 6-panel design makes for easy styling.</li><li>The Swoosh branded metal tri-glide lets you adjust your fit with ease.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>A metal Swoosh Ingot logo</li><li>An adjustable metal clamp closure with Embossed Swoosh</li><li>Hand-wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 3],
                'tags'       => ['Hats'],
                'image_path' => 'juniors/accessories',
                'images'     => [1, 2, 3, 4]
            ],
            [
                'info'       => [
                    'name'             => 'Snapback Hat',
                    'category'         => 45,
                    'brand'            => 8,
                    'buying_price'     => 80,
                    'selling_price'    => 100,
                    'variation_price'  => 100,
                    'purchasable'      => Ask::YES,
                    'refundable'       => Ask::YES,
                    'flash_sale'       => Ask::YES,
                    'discount'         => 50,
                    'offer_start_date' => now(),
                    'offer_end_date'   => Carbon::now()->addDay(365),
                    'description'      => "<p>Step your Swoosh game up with this mid-depth, unstructured Club Cap. Its curved bill and metal Swoosh logo give your look a clean finish while sweat-wicking tech helps you stay cool and comfortable while you make the most of warm, sunny weather.</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Twill fabric has a lightweight, smooth feel.</li><li>A mid-depth, 6-panel design makes for easy styling.</li><li>The Swoosh branded metal tri-glide lets you adjust your fit with ease.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>A metal Swoosh Ingot logo</li><li>An adjustable metal clamp closure with Embossed Swoosh</li><li>Hand-wash</li><li>Imported</li></ul>",
                ],
                'seo'        => [
                    'title'        => 'Snapback Hat',
                    'meta_keyword' => ['Hats'],
                    'description'  => "<p>Step your Swoosh game up with this mid-depth, unstructured Club Cap. Its curved bill and metal Swoosh logo give your look a clean finish while sweat-wicking tech helps you stay cool and comfortable while you make the most of warm, sunny weather.</p><p><br></p><p>Benefits</p><ul><li>Nike Dri-FIT technology moves sweat away from your skin for quicker evaporation, helping you stay dry and comfortable.</li><li>Twill fabric has a lightweight, smooth feel.</li><li>A mid-depth, 6-panel design makes for easy styling.</li><li>The Swoosh branded metal tri-glide lets you adjust your fit with ease.</li></ul><p><br></p><p>Product Details</p><ul><li>100% polyester</li><li>A metal Swoosh Ingot logo</li><li>An adjustable metal clamp closure with Embossed Swoosh</li><li>Hand-wash</li><li>Imported</li></ul>",
                ],
                'taxes'      => [2, 4],
                'tags'       => ['Hats'],
                'image_path' => 'juniors/accessories',
                'images'     => [1, 2, 3, 4]
            ]
        ];

        $envService = new EnvEditor();
        if ($envService->getValue('DEMO') && $envService->getValue('DISPLAY_TYPE') == 'fashion') {
            foreach ($fashionProducts as $fashionProduct) {
                $sku = rand(100, 999) .date('is');
                $productObject = Product::create([
                    'name'                         => $fashionProduct['info']['name'],
                    'slug'                         => Str::slug($fashionProduct['info']['name'] . rand(1, 1000)),
                    'sku'                          => $sku,
                    'product_category_id'          => $fashionProduct['info']['category'],
                    'product_brand_id'             => $fashionProduct['info']['brand'],
                    'barcode_id'                   => 1,
                    'unit_id'                      => 1,
                    'buying_price'                 => $fashionProduct['info']['buying_price'],
                    'selling_price'                => $fashionProduct['info']['selling_price'],
                    'variation_price'              => $fashionProduct['info']['variation_price'],
                    'status'                       => Status::ACTIVE,
                    'order'                        => 1,
                    'can_purchasable'              => $fashionProduct['info']['purchasable'],
                    'show_stock_out'               => Activity::DISABLE,
                    'maximum_purchase_quantity'    => 100,
                    'low_stock_quantity_warning'   => 2,
                    'weight'                       => null,
                    'refundable'                   => $fashionProduct['info']['refundable'],
                    'add_to_flash_sale'            => $fashionProduct['info']['flash_sale'],
                    'discount'                     => $fashionProduct['info']['discount'],
                    'offer_start_date'             => $fashionProduct['info']['offer_start_date'],
                    'offer_end_date'               => $fashionProduct['info']['offer_end_date'],
                    'shipping_type'                => ShippingType::FLAT_RATE,
                    'shipping_cost'                => 80,
                    'is_product_quantity_multiply' => Ask::NO,
                    'description'                  => $fashionProduct['info']['description'],
                    'shipping_and_return'          => "<ul><li>We offer extended returns throughout the holiday season. All purchases made between November 6, 2023, through January 7, 2024, can be returned until Jan 31, 2024. Returns are accepted by mail and in-store. Items must be unworn and tags must be attached.</li><li>A flat rate of $4.95 USD will be deducted from your refund for returns.</li><li>Once a return is received, please allow 7-14 business days to process and 3-5 business days for the refund to be credited to the payment method used at the time of purchase.</li><li>We do not offer item exchanges for online orders at this time. To exchange an item for a new size or color you must return the unwanted item(s) and place a new web order for the desired item(s). Your returned item will be processed and a refund will be granted to the original form of payment as long as the item meets our return policy terms. Availability of replacement items is not guaranteed.</li></ul><p><br></p><p><br></p><p><br></p><p><br></p>",
                ]);

                $generator     = new BarcodeGeneratorJPG();
                $barcode_value = str_pad($sku, 12, '0', STR_PAD_LEFT);
                $barcode       = $generator->getBarcode($barcode_value, $generator::TYPE_EAN_13);
                $tempFilePath  = storage_path('app/public/barcode.jpg');
                file_put_contents($tempFilePath, $barcode);
                $productObject->addMedia($tempFilePath)->toMediaCollection('product-barcode');

                if (isset($fashionProduct['taxes']) && count($fashionProduct['taxes'])) {
                    foreach ($fashionProduct['taxes'] as $tax) {
                        ProductTax::create([
                            'product_id' => $productObject->id,
                            'tax_id'     => $tax
                        ]);
                    }
                }

                if (isset($fashionProduct['tags']) && count($fashionProduct['tags'])) {
                    foreach ($fashionProduct['tags'] as $tag) {
                        ProductTag::create([
                            'product_id' => $productObject->id,
                            'name'       => $tag
                        ]);
                    }
                }

                if (isset($fashionProduct['seo'])) {
                    $productSeo = ProductSeo::create([
                        'product_id'   => $productObject->id,
                        'title'        => $fashionProduct['seo']['title'],
                        'meta_keyword' => json_encode($fashionProduct['seo']['meta_keyword']),
                        'description'  => $fashionProduct['seo']['description']
                    ]);
                    if (isset($fashionProduct['images']) && count($fashionProduct['images'])) {
                        if (file_exists(public_path('/images/seeder/product/' . env('DISPLAY_TYPE') . '/' . $fashionProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $fashionProduct['info']['name'])) . '/' . '1.png'))) {
                            $productSeo->addMedia(public_path('/images/seeder/product/' . env('DISPLAY_TYPE') . '/' . $fashionProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $fashionProduct['info']['name'])) . '/' . '1.png'))->preservingOriginal()->toMediaCollection('product-seo');
                        }
                    }
                }

                if (isset($fashionProduct['images']) && count($fashionProduct['images'])) {
                    foreach ($fashionProduct['images'] as $image) {
                        if (file_exists(public_path('/images/seeder/product/' . env('DISPLAY_TYPE') . '/' . $fashionProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $fashionProduct['info']['name'])) . '/' . $image . '.png'))) {
                            $productObject->addMedia(public_path('/images/seeder/product/' . env('DISPLAY_TYPE') . '/' . $fashionProduct['image_path'] . '/' . strtolower(str_replace(' ', '_', $fashionProduct['info']['name'])) . '/' . $image . '.png'))->preservingOriginal()->toMediaCollection('product');
                        }
                    }
                }
            }
        }
    }
}