<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class WireGroupTopology extends \Google\Collection
{
  protected $collection_key = 'endpoints';
  protected $endpointsType = WireGroupTopologyEndpoint::class;
  protected $endpointsDataType = 'array';

  /**
   * Topology details for all endpoints in the wire group.
   *
   * @param WireGroupTopologyEndpoint[] $endpoints
   */
  public function setEndpoints($endpoints)
  {
    $this->endpoints = $endpoints;
  }
  /**
   * @return WireGroupTopologyEndpoint[]
   */
  public function getEndpoints()
  {
    return $this->endpoints;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WireGroupTopology::class, 'Google_Service_Compute_WireGroupTopology');
